
# Variable:ABSNTPAY Format: ABSNTPAF levels:3
Harmon$ABSNTPAY <- as.factor(Harmon$ABSNTPAY)
all_values <- c(-1 ,1  , 2 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$ABSNTPAY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ABSNTPAY)[valid_positions] <- valid_labels
table(Harmon$ABSNTPAY, useNA="ifany")


# Variable:ABSNTRSN Format: ABSNTRSF levels:15
Harmon$ABSNTRSN <- as.factor(Harmon$ABSNTRSN)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14 ) 
all_levels <- c("-1: Not in universe" ,
                "1: On layoff"  , 
                "2: Slack work/business conditions"  , 
                "3: Waiting for a new job to begin"  , 
                "4: Vacation/personal days"  , 
                "5: Own illness/injury/medical problems"  , 
                "6: Child care problems"  , 
                "7: Other family/personal obligation"  , 
                "8: Maternity/paternity leave"  , 
                "9: Labor dispute"  , 
                "10: Weather affected job"  , 
                "11: School/training"  , 
                "12: Civic/military duty"  , 
                "13: Does not work in the business"  , 
                "14: Other" ) 
var_levels <-  levels(Harmon$ABSNTRSN)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ABSNTRSN)[valid_positions] <- valid_labels
table(Harmon$ABSNTRSN, useNA="ifany")


# Variable:AFEver Format: AFEVERF levels:6
Harmon$AFEver <- as.factor(Harmon$AFEver)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$AFEver)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$AFEver)[valid_positions] <- valid_labels
table(Harmon$AFEver, useNA="ifany")


# Variable:ATMINBUY Format: ATMINBUF levels:8
Harmon$ATMINBUY <- as.factor(Harmon$ATMINBUY)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3  , 4 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Very easy"  , 
                "2: Somewhat easy"  , 
                "3: Somewhat difficult"  , 
                "4: Very difficult" ) 
var_levels <-  levels(Harmon$ATMINBUY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ATMINBUY)[valid_positions] <- valid_labels
table(Harmon$ATMINBUY, useNA="ifany")


# Variable:ATSAMPLE Format: ATSAMPLF levels:7
Harmon$ATSAMPLE <- as.factor(Harmon$ATSAMPLE)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Always allowed"  , 
                "2: Allowed under some conditions"  , 
                "3: Not allowed at all" ) 
var_levels <-  levels(Harmon$ATSAMPLE)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ATSAMPLE)[valid_positions] <- valid_labels
table(Harmon$ATSAMPLE, useNA="ifany")


# Variable:ATSMCARC Format: ATSMCARF levels:7
Harmon$ATSMCARC <- as.factor(Harmon$ATSMCARC)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Always be allowed"  , 
                "2: Be allowed under some conditions"  , 
                "3: Never be allowed" ) 
var_levels <-  levels(Harmon$ATSMCARC)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ATSMCARC)[valid_positions] <- valid_labels
table(Harmon$ATSMCARC, useNA="ifany")


# Variable:ATSMCARO Format: ATSMCARF levels:7
Harmon$ATSMCARO <- as.factor(Harmon$ATSMCARO)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Always be allowed"  , 
                "2: Be allowed under some conditions"  , 
                "3: Never be allowed" ) 
var_levels <-  levels(Harmon$ATSMCARO)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ATSMCARO)[valid_positions] <- valid_labels
table(Harmon$ATSMCARO, useNA="ifany")


# Variable:ATSMKBAR Format: ATSMKF levels:7
Harmon$ATSMKBAR <- as.factor(Harmon$ATSMKBAR)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Allowed in all areas"  , 
                "2: Allowed in some areas"  , 
                "3: Not allowed at all" ) 
var_levels <-  levels(Harmon$ATSMKBAR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ATSMKBAR)[valid_positions] <- valid_labels
table(Harmon$ATSMKBAR, useNA="ifany")


# Variable:ATSMKCAS Format: ATSMKF levels:7
Harmon$ATSMKCAS <- as.factor(Harmon$ATSMKCAS)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Allowed in all areas"  , 
                "2: Allowed in some areas"  , 
                "3: Not allowed at all" ) 
var_levels <-  levels(Harmon$ATSMKCAS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ATSMKCAS)[valid_positions] <- valid_labels
table(Harmon$ATSMKCAS, useNA="ifany")


# Variable:ATSMKHSP Format: ATSMKF levels:7
Harmon$ATSMKHSP <- as.factor(Harmon$ATSMKHSP)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Allowed in all areas"  , 
                "2: Allowed in some areas"  , 
                "3: Not allowed at all" ) 
var_levels <-  levels(Harmon$ATSMKHSP)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ATSMKHSP)[valid_positions] <- valid_labels
table(Harmon$ATSMKHSP, useNA="ifany")


# Variable:ATSMKISM Format: ATSMKF levels:7
Harmon$ATSMKISM <- as.factor(Harmon$ATSMKISM)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Allowed in all areas"  , 
                "2: Allowed in some areas"  , 
                "3: Not allowed at all" ) 
var_levels <-  levels(Harmon$ATSMKISM)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ATSMKISM)[valid_positions] <- valid_labels
table(Harmon$ATSMKISM, useNA="ifany")


# Variable:ATSMKISP Format: ATSMKF levels:7
Harmon$ATSMKISP <- as.factor(Harmon$ATSMKISP)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Allowed in all areas"  , 
                "2: Allowed in some areas"  , 
                "3: Not allowed at all" ) 
var_levels <-  levels(Harmon$ATSMKISP)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ATSMKISP)[valid_positions] <- valid_labels
table(Harmon$ATSMKISP, useNA="ifany")


# Variable:ATSMKIWA Format: ATSMKF levels:7
Harmon$ATSMKIWA <- as.factor(Harmon$ATSMKIWA)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Allowed in all areas"  , 
                "2: Allowed in some areas"  , 
                "3: Not allowed at all" ) 
var_levels <-  levels(Harmon$ATSMKIWA)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ATSMKIWA)[valid_positions] <- valid_labels
table(Harmon$ATSMKIWA, useNA="ifany")


# Variable:ATSMKPLY Format: ATSMKF levels:7
Harmon$ATSMKPLY <- as.factor(Harmon$ATSMKPLY)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Allowed in all areas"  , 
                "2: Allowed in some areas"  , 
                "3: Not allowed at all" ) 
var_levels <-  levels(Harmon$ATSMKPLY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ATSMKPLY)[valid_positions] <- valid_labels
table(Harmon$ATSMKPLY, useNA="ifany")


# Variable:ATSMKRST Format: ATSMKF levels:7
Harmon$ATSMKRST <- as.factor(Harmon$ATSMKRST)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Allowed in all areas"  , 
                "2: Allowed in some areas"  , 
                "3: Not allowed at all" ) 
var_levels <-  levels(Harmon$ATSMKRST)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ATSMKRST)[valid_positions] <- valid_labels
table(Harmon$ATSMKRST, useNA="ifany")


# Variable:ATTOBADV Format: ATTOBADF levels:7
Harmon$ATTOBADV <- as.factor(Harmon$ATTOBADV)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Always allowed"  , 
                "2: Allowed under some conditions"  , 
                "3: Not allowed at all" ) 
var_levels <-  levels(Harmon$ATTOBADV)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ATTOBADV)[valid_positions] <- valid_labels
table(Harmon$ATTOBADV, useNA="ifany")


# Variable:Age Format: AGEF levels:1
Harmon$Age <- as.factor(Harmon$Age)
all_values <- c(80 )
all_levels <- c("80 and over" )
var_levels <-  levels(Harmon$Age)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$Age)[valid_positions] <- valid_labels
table(Harmon$Age, useNA="ifany")



# Variable:AgeInUS Format: AGEINUSF levels:3
Harmon$AgeInUS <- as.factor(Harmon$AgeInUS)
all_values <- c(-9 ,-1  , 4 ) 
all_levels <- c("Indeterminate" ,
                "-1: Not in universe"  , 
                "Less than 5 Years Old" ) 
var_levels <-  levels(Harmon$AgeInUS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$AgeInUS)[valid_positions] <- valid_labels
table(Harmon$AgeInUS, useNA="ifany")


# Variable:BUYCIG Format: BUYCIGF levels:6
Harmon$BUYCIG <- as.factor(Harmon$BUYCIG)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$BUYCIG)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$BUYCIG)[valid_positions] <- valid_labels
table(Harmon$BUYCIG, useNA="ifany")


# Variable:BUYPKCR Format: BUYPKCRF levels:7
Harmon$BUYPKCR <- as.factor(Harmon$BUYPKCR)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Pack"  , 
                "2: Carton"  , 
                "3: Both" ) 
var_levels <-  levels(Harmon$BUYPKCR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$BUYPKCR)[valid_positions] <- valid_labels
table(Harmon$BUYPKCR, useNA="ifany")


# Variable:CGSTCRY Format: CGSTCRYF levels:204
Harmon$CGSTCRY <- as.factor(Harmon$CGSTCRY)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 4  , 5  , 6  , 8  , 9  , 10  , 11  , 12  , 13  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23  , 24  , 25  , 26  , 27  , 28  , 29  , 30  , 31  , 32  , 33  , 34  , 35  , 36  , 37  , 38  , 39  , 40  , 41  , 42  , 44  , 45  , 46  , 47  , 48  , 49
 , 50  , 51  , 53  , 54  , 55  , 56  , 57  , 66  , 73  , 78  , 96  , 100  , 102  , 103  , 104  , 105  , 106  , 108  , 109  , 110  , 116  , 117  , 119  , 120  , 126  , 127  , 128  , 129  , 130  , 132  , 134  , 136  , 137  , 138  , 139  , 140  , 141  , 142  , 147  , 148  , 149  , 150  , 151  , 152  , 
154  , 156  , 157  , 158  , 159  , 160  , 161  , 162  , 163  , 164  , 165  , 166  , 167  , 200  , 202  , 205  , 206  , 207  , 208  , 209  , 210  , 211  , 212  , 213  , 214  , 215  , 216  , 217  , 220  , 222  , 223  , 224  , 226  , 229  , 231  , 233  , 235  , 236  , 238  , 239  , 240  , 242  , 243
 , 246  , 247  , 248  , 249  , 300  , 301  , 303  , 310  , 311  , 312  , 313  , 314  , 315  , 316  , 321  , 323  , 324  , 327  , 328  , 329  , 330  , 332  , 333  , 338  , 339  , 340  , 341  , 343  , 360  , 361  , 362  , 363  , 364  , 365  , 368  , 369  , 370  , 372  , 373  , 374  , 399  , 400  , 407
 , 408  , 414  , 416  , 417  , 421  , 427  , 429  , 436  , 440  , 444  , 447  , 448  , 449  , 451  , 453  , 457  , 461  , 462  , 501  , 508  , 515  , 523  , 527  , 528  , 555 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Alabama"  , 
                "2: Alaska"  , 
                "4: Arizona"  , 
                "5: Arkansas"  , 
                "6: California"  , 
                "8: Colorado"  , 
                "9: Connecticut"  , 
                "10: Delaware"  , 
                "11: District of Columbia"  , 
                "12: Florida"  , 
                "13: Georgia"  , 
                "15: Hawaii"  , 
                "16: Idaho"  , 
                "17: Illinois"  , 
                "18: Indiana"  , 
                "19: Iowa"  , 
                "20: Kansas"  , 
                "21: Kentucky"  , 
                "22: Louisiana"  , 
                "23: Maine"  , 
                "24: Maryland"  , 
                "25: Massachusetts"  , 
                "26: Michigan"  , 
                "27: Minnesota"  , 
                "28: Mississippi"  , 
                "29: Missouri"  , 
                "30: Montana"  , 
                "31: Nebraska"  , 
                "32: Nevada"  , 
                "33: New Hampshire"  , 
                "34: New Jersey"  , 
                "35: New Mexico"  , 
                "36: New York"  , 
                "37: North Carolina"  , 
                "38: North Dakota"  , 
                "39: Ohio"  , 
                "40: Oklahoma"  , 
                "41: Oregon"  , 
                "42: Pennsylvania"  , 
                "44: Rhode Island"  , 
                "45: South Carolina"  , 
                "46: South Dakota"  , 
                "47: Tennessee"  , 
                "48: Texas"  , 
                "49: Utah"  , 
                "50: Vermont"  , 
                "51: Virginia"  , 
                "53: Washington"  , 
                "54: West Virginia"  , 
                "55: Wisconsin"  , 
                "56: Wyoming"  , 
                "57: United States (state unknown)"  , 
                "66: Guam"  , 
                "73: Puerto Rico"  , 
                "78: U. S. Virgin Islands"  , 
                "96: Other U. S. Island Areas"  , 
                "100: Albania"  , 
                "102: Austria"  , 
                "103: Belgium"  , 
                "104: Bulgaria"  , 
                "105: Czechoslovakia"  , 
                "106: Denmark"  , 
                "108: Finland"  , 
                "109: France"  , 
                "110: Germany"  , 
                "116: Greece"  , 
                "117: Hungary"  , 
                "119: Ireland"  , 
                "120: Italy"  , 
                "126: Netherlands"  , 
                "127: Norway"  , 
                "128: Poland"  , 
                "129: Portugal"  , 
                "130: Azores"  , 
                "132: Romania"  , 
                "134: Spain"  , 
                "136: Sweden"  , 
                "137: Switzerland"  , 
                "138: United Kingdom"  , 
                "139: England"  , 
                "140: Scotland"  , 
                "141: Wales"  , 
                "142: Northern Ireland"  , 
                "147: Yugoslavia"  , 
                "148: Czech Republic"  , 
                "149: Slovakia"  , 
                "150: Bosnia & Herzegovina"  , 
                "151: Croatia"  , 
                "152: Macedonia"  , 
                "154: Serbia"  , 
                "156: Latvia"  , 
                "157: Lithuania"  , 
                "158: Armenia"  , 
                "159: Azerbaijan"  , 
                "160: Belarus"  , 
                "161: Georgia"  , 
                "162: Moldova"  , 
                "163: Russia"  , 
                "164: Ukraine"  , 
                "165: USSR"  , 
                "166: Europe, not specified"  , 
                "167: Kosovo"  , 
                "200: Afghanistan"  , 
                "202: Bangladesh"  , 
                "205: Myanmar (Burma)"  , 
                "206: Cambodia"  , 
                "207: China"  , 
                "208: Cyprus"  , 
                "209: Hong Kong"  , 
                "210: India"  , 
                "211: Indonesia"  , 
                "212: Iran"  , 
                "213: Iraq"  , 
                "214: Israel"  , 
                "215: Japan"  , 
                "216: Jordan"  , 
                "217: Korea"  , 
                "220: South Korea"  , 
                "222: Kuwait"  , 
                "223: Laos"  , 
                "224: Lebanon"  , 
                "226: Malaysia"  , 
                "229: Nepal"  , 
                "231: Pakistan"  , 
                "233: Philippines"  , 
                "235: Saudi Arabia"  , 
                "236: Singapore"  , 
                "238: Sri Lanka"  , 
                "239: Syria"  , 
                "240: Taiwan"  , 
                "242: Thailand"  , 
                "243: Turkey"  , 
                "246: Uzbekistan"  , 
                "247: Vietnam"  , 
                "248: Yemen"  , 
                "249: Asia, not specified"  , 
                "300: Bermuda"  , 
                "301: Canada"  , 
                "303: Mexico"  , 
                "310: Belize"  , 
                "311: Costa Rica"  , 
                "312: El Salvador"  , 
                "313: Guatemala"  , 
                "314: Honduras"  , 
                "315: Nicaragua"  , 
                "316: Panama"  , 
                "321: Antigua and Barbuda"  , 
                "323: Bahamas"  , 
                "324: Barbados"  , 
                "327: Cuba"  , 
                "328: Dominica"  , 
                "329: Dominican Republic"  , 
                "330: Grenada"  , 
                "332: Haiti"  , 
                "333: Jamaica"  , 
                "338: St. Kitts--Nevis"  , 
                "339: St. Lucia"  , 
                "340: St. Vincent and the Grenadines"  , 
                "341: Trinidad and Tobago"  , 
                "343: West Indies, not specified"  , 
                "360: Argentina"  , 
                "361: Bolivia"  , 
                "362: Brazil"  , 
                "363: Chile"  , 
                "364: Columbia"  , 
                "365: Ecuador"  , 
                "368: Guyana"  , 
                "369: Paraguay"  , 
                "370: Peru"  , 
                "372: Uruguay"  , 
                "373: Venezuela"  , 
                "374: South America, not specified"  , 
                "399: Americas, not specified"  , 
                "400: Algeria"  , 
                "407: Cameroon"  , 
                "408: Cape Verde"  , 
                "414: Egypt"  , 
                "416: Ethiopia"  , 
                "417: Eritrea"  , 
                "421: Ghana"  , 
                "427: Kenya"  , 
                "429: Liberia"  , 
                "436: Morocco"  , 
                "440: Nigeria"  , 
                "444: Senegal"  , 
                "447: Sierra Leone"  , 
                "448: Somalia"  , 
                "449: South Africa"  , 
                "451: Sudan"  , 
                "453: Tanzania"  , 
                "457: Uganda"  , 
                "461: Zimbabwe"  , 
                "462: Africa, not specified"  , 
                "501: Australia"  , 
                "508: Fiji"  , 
                "515: New Zealand"  , 
                "523: Tonga"  , 
                "527: Samoa"  , 
                "528: Oceania, not specified"  , 
                "555: Elsewhere" ) 
var_levels <-  levels(Harmon$CGSTCRY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CGSTCRY)[valid_positions] <- valid_labels
table(Harmon$CGSTCRY, useNA="ifany")


# Variable:CGSTCRYX Format: CGSTCRYF levels:204
Harmon$CGSTCRYX <- as.factor(Harmon$CGSTCRYX)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 4  , 5  , 6  , 8  , 9  , 10  , 11  , 12  , 13  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23  , 24  , 25  , 26  , 27  , 28  , 29  , 30  , 31  , 32  , 33  , 34  , 35  , 36  , 37  , 38  , 39  , 40  , 41  , 42  , 44  , 45  , 46  , 47  , 48  , 49
 , 50  , 51  , 53  , 54  , 55  , 56  , 57  , 66  , 73  , 78  , 96  , 100  , 102  , 103  , 104  , 105  , 106  , 108  , 109  , 110  , 116  , 117  , 119  , 120  , 126  , 127  , 128  , 129  , 130  , 132  , 134  , 136  , 137  , 138  , 139  , 140  , 141  , 142  , 147  , 148  , 149  , 150  , 151  , 152  , 
154  , 156  , 157  , 158  , 159  , 160  , 161  , 162  , 163  , 164  , 165  , 166  , 167  , 200  , 202  , 205  , 206  , 207  , 208  , 209  , 210  , 211  , 212  , 213  , 214  , 215  , 216  , 217  , 220  , 222  , 223  , 224  , 226  , 229  , 231  , 233  , 235  , 236  , 238  , 239  , 240  , 242  , 243
 , 246  , 247  , 248  , 249  , 300  , 301  , 303  , 310  , 311  , 312  , 313  , 314  , 315  , 316  , 321  , 323  , 324  , 327  , 328  , 329  , 330  , 332  , 333  , 338  , 339  , 340  , 341  , 343  , 360  , 361  , 362  , 363  , 364  , 365  , 368  , 369  , 370  , 372  , 373  , 374  , 399  , 400  , 407
 , 408  , 414  , 416  , 417  , 421  , 427  , 429  , 436  , 440  , 444  , 447  , 448  , 449  , 451  , 453  , 457  , 461  , 462  , 501  , 508  , 515  , 523  , 527  , 528  , 555 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Alabama"  , 
                "2: Alaska"  , 
                "4: Arizona"  , 
                "5: Arkansas"  , 
                "6: California"  , 
                "8: Colorado"  , 
                "9: Connecticut"  , 
                "10: Delaware"  , 
                "11: District of Columbia"  , 
                "12: Florida"  , 
                "13: Georgia"  , 
                "15: Hawaii"  , 
                "16: Idaho"  , 
                "17: Illinois"  , 
                "18: Indiana"  , 
                "19: Iowa"  , 
                "20: Kansas"  , 
                "21: Kentucky"  , 
                "22: Louisiana"  , 
                "23: Maine"  , 
                "24: Maryland"  , 
                "25: Massachusetts"  , 
                "26: Michigan"  , 
                "27: Minnesota"  , 
                "28: Mississippi"  , 
                "29: Missouri"  , 
                "30: Montana"  , 
                "31: Nebraska"  , 
                "32: Nevada"  , 
                "33: New Hampshire"  , 
                "34: New Jersey"  , 
                "35: New Mexico"  , 
                "36: New York"  , 
                "37: North Carolina"  , 
                "38: North Dakota"  , 
                "39: Ohio"  , 
                "40: Oklahoma"  , 
                "41: Oregon"  , 
                "42: Pennsylvania"  , 
                "44: Rhode Island"  , 
                "45: South Carolina"  , 
                "46: South Dakota"  , 
                "47: Tennessee"  , 
                "48: Texas"  , 
                "49: Utah"  , 
                "50: Vermont"  , 
                "51: Virginia"  , 
                "53: Washington"  , 
                "54: West Virginia"  , 
                "55: Wisconsin"  , 
                "56: Wyoming"  , 
                "57: United States (state unknown)"  , 
                "66: Guam"  , 
                "73: Puerto Rico"  , 
                "78: U. S. Virgin Islands"  , 
                "96: Other U. S. Island Areas"  , 
                "100: Albania"  , 
                "102: Austria"  , 
                "103: Belgium"  , 
                "104: Bulgaria"  , 
                "105: Czechoslovakia"  , 
                "106: Denmark"  , 
                "108: Finland"  , 
                "109: France"  , 
                "110: Germany"  , 
                "116: Greece"  , 
                "117: Hungary"  , 
                "119: Ireland"  , 
                "120: Italy"  , 
                "126: Netherlands"  , 
                "127: Norway"  , 
                "128: Poland"  , 
                "129: Portugal"  , 
                "130: Azores"  , 
                "132: Romania"  , 
                "134: Spain"  , 
                "136: Sweden"  , 
                "137: Switzerland"  , 
                "138: United Kingdom"  , 
                "139: England"  , 
                "140: Scotland"  , 
                "141: Wales"  , 
                "142: Northern Ireland"  , 
                "147: Yugoslavia"  , 
                "148: Czech Republic"  , 
                "149: Slovakia"  , 
                "150: Bosnia & Herzegovina"  , 
                "151: Croatia"  , 
                "152: Macedonia"  , 
                "154: Serbia"  , 
                "156: Latvia"  , 
                "157: Lithuania"  , 
                "158: Armenia"  , 
                "159: Azerbaijan"  , 
                "160: Belarus"  , 
                "161: Georgia"  , 
                "162: Moldova"  , 
                "163: Russia"  , 
                "164: Ukraine"  , 
                "165: USSR"  , 
                "166: Europe, not specified"  , 
                "167: Kosovo"  , 
                "200: Afghanistan"  , 
                "202: Bangladesh"  , 
                "205: Myanmar (Burma)"  , 
                "206: Cambodia"  , 
                "207: China"  , 
                "208: Cyprus"  , 
                "209: Hong Kong"  , 
                "210: India"  , 
                "211: Indonesia"  , 
                "212: Iran"  , 
                "213: Iraq"  , 
                "214: Israel"  , 
                "215: Japan"  , 
                "216: Jordan"  , 
                "217: Korea"  , 
                "220: South Korea"  , 
                "222: Kuwait"  , 
                "223: Laos"  , 
                "224: Lebanon"  , 
                "226: Malaysia"  , 
                "229: Nepal"  , 
                "231: Pakistan"  , 
                "233: Philippines"  , 
                "235: Saudi Arabia"  , 
                "236: Singapore"  , 
                "238: Sri Lanka"  , 
                "239: Syria"  , 
                "240: Taiwan"  , 
                "242: Thailand"  , 
                "243: Turkey"  , 
                "246: Uzbekistan"  , 
                "247: Vietnam"  , 
                "248: Yemen"  , 
                "249: Asia, not specified"  , 
                "300: Bermuda"  , 
                "301: Canada"  , 
                "303: Mexico"  , 
                "310: Belize"  , 
                "311: Costa Rica"  , 
                "312: El Salvador"  , 
                "313: Guatemala"  , 
                "314: Honduras"  , 
                "315: Nicaragua"  , 
                "316: Panama"  , 
                "321: Antigua and Barbuda"  , 
                "323: Bahamas"  , 
                "324: Barbados"  , 
                "327: Cuba"  , 
                "328: Dominica"  , 
                "329: Dominican Republic"  , 
                "330: Grenada"  , 
                "332: Haiti"  , 
                "333: Jamaica"  , 
                "338: St. Kitts--Nevis"  , 
                "339: St. Lucia"  , 
                "340: St. Vincent and the Grenadines"  , 
                "341: Trinidad and Tobago"  , 
                "343: West Indies, not specified"  , 
                "360: Argentina"  , 
                "361: Bolivia"  , 
                "362: Brazil"  , 
                "363: Chile"  , 
                "364: Columbia"  , 
                "365: Ecuador"  , 
                "368: Guyana"  , 
                "369: Paraguay"  , 
                "370: Peru"  , 
                "372: Uruguay"  , 
                "373: Venezuela"  , 
                "374: South America, not specified"  , 
                "399: Americas, not specified"  , 
                "400: Algeria"  , 
                "407: Cameroon"  , 
                "408: Cape Verde"  , 
                "414: Egypt"  , 
                "416: Ethiopia"  , 
                "417: Eritrea"  , 
                "421: Ghana"  , 
                "427: Kenya"  , 
                "429: Liberia"  , 
                "436: Morocco"  , 
                "440: Nigeria"  , 
                "444: Senegal"  , 
                "447: Sierra Leone"  , 
                "448: Somalia"  , 
                "449: South Africa"  , 
                "451: Sudan"  , 
                "453: Tanzania"  , 
                "457: Uganda"  , 
                "461: Zimbabwe"  , 
                "462: Africa, not specified"  , 
                "501: Australia"  , 
                "508: Fiji"  , 
                "515: New Zealand"  , 
                "523: Tonga"  , 
                "527: Samoa"  , 
                "528: Oceania, not specified"  , 
                "555: Elsewhere" ) 
var_levels <-  levels(Harmon$CGSTCRYX)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CGSTCRYX)[valid_positions] <- valid_labels
table(Harmon$CGSTCRYX, useNA="ifany")


# Variable:CHEWCURR Format: OTPCURRF levels:8
Harmon$CHEWCURR <- as.factor(Harmon$CHEWCURR)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: Indeterminate" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Never"  , 
                "2: Current"  , 
                "3: Former" ) 
var_levels <-  levels(Harmon$CHEWCURR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CHEWCURR)[valid_positions] <- valid_labels
table(Harmon$CHEWCURR, useNA="ifany")


# Variable:CHEWDAY Format: OTPDAYF levels:5
Harmon$CHEWDAY <- as.factor(Harmon$CHEWDAY)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No Response" ,
                "-5: Did not use in the past 30 days"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$CHEWDAY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CHEWDAY)[valid_positions] <- valid_labels
table(Harmon$CHEWDAY, useNA="ifany")


# Variable:CHEWEVER Format: OTPEVERF levels:7
Harmon$CHEWEVER <- as.factor(Harmon$CHEWEVER)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$CHEWEVER)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CHEWEVER)[valid_positions] <- valid_labels
table(Harmon$CHEWEVER, useNA="ifany")


# Variable:CHEWNOW Format: OTPNOWF levels:7
Harmon$CHEWNOW <- as.factor(Harmon$CHEWNOW)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$CHEWNOW)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CHEWNOW)[valid_positions] <- valid_labels
table(Harmon$CHEWNOW, useNA="ifany")


# Variable:CHEWNOW2 Format: OTPNOW2F levels:8
Harmon$CHEWNOW2 <- as.factor(Harmon$CHEWNOW2)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Every day"  , 
                "2: Some days"  , 
                "3: Former" ) 
var_levels <-  levels(Harmon$CHEWNOW2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CHEWNOW2)[valid_positions] <- valid_labels
table(Harmon$CHEWNOW2, useNA="ifany")


# Variable:CHEWSTAT Format: OTPSTATF levels:9
Harmon$CHEWSTAT <- as.factor(Harmon$CHEWSTAT)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3  , 4 ) 
all_levels <- c("-9: Indeterminate" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Never"  , 
                "2: Every day"  , 
                "3: Some days"  , 
                "4: Former" ) 
var_levels <-  levels(Harmon$CHEWSTAT)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CHEWSTAT)[valid_positions] <- valid_labels
table(Harmon$CHEWSTAT, useNA="ifany")


# Variable:CHILD Format: CHILDF levels:17
Harmon$CHILD <- as.factor(Harmon$CHILD)
all_values <- c(-1 ,0  , 1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14  , 15 ) 
all_levels <- c("-1: Not in universe" ,
                "0: No own children under 18 years of age"  , 
                "1: All own children 0-2 years of age"  , 
                "2: All own children 3-5 years of age"  , 
                "3: All own children 6-13 years of age"  , 
                "4: All own children 14-17 years of age"  , 
                "5: Own children 0-2 and 3-5 years of age (none 6-17)"  , 
                "6: Own children 0-2 and 6-13 years of age (none 3-5 or 14-17)"  , 
                "7: Own children 0-2 and 14-17 years of age (none 3-13)"  , 
                "8: Own children 3-5 and 6-13 years of age (none 0-2 or 14-17)"  , 
                "9: Own children 3-5 and 14-17 years of age (none 0-2 or 6-13)"  , 
                "10: Own children 6-13 and 14-17 years of age (none 0-5)"  , 
                "11: Own children 0-2, 3-5 and 6-13 years of age (none 14-17)"  , 
                "12: Own children 0-2, 3-5 and 14-17 years of age (none 6-13)"  , 
                "13: Own children 0-2, 6-13 and 14-17 years of age (none 3-5)"  , 
                "14: Own children 3-5, 6-13 and 14-17 years of age (none 0-2)"  , 
                "15: Own children from all age groups (0-2, 3-5, 6-13 and 14-17)" ) 
var_levels <-  levels(Harmon$CHILD)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CHILD)[valid_positions] <- valid_labels
table(Harmon$CHILD, useNA="ifany")


# Variable:CHILD13 Format: CHILDRF levels:3
Harmon$CHILD13 <- as.factor(Harmon$CHILD13)
all_values <- c(-1 ,1  , 2 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$CHILD13)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CHILD13)[valid_positions] <- valid_labels
table(Harmon$CHILD13, useNA="ifany")


# Variable:CHILD17 Format: CHILDRF levels:3
Harmon$CHILD17 <- as.factor(Harmon$CHILD17)
all_values <- c(-1 ,1  , 2 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$CHILD17)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CHILD17)[valid_positions] <- valid_labels
table(Harmon$CHILD17, useNA="ifany")


# Variable:CHILD2 Format: CHILDRF levels:3
Harmon$CHILD2 <- as.factor(Harmon$CHILD2)
all_values <- c(-1 ,1  , 2 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$CHILD2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CHILD2)[valid_positions] <- valid_labels
table(Harmon$CHILD2, useNA="ifany")


# Variable:CHILD5 Format: CHILDRF levels:3
Harmon$CHILD5 <- as.factor(Harmon$CHILD5)
all_values <- c(-1 ,1  , 2 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$CHILD5)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CHILD5)[valid_positions] <- valid_labels
table(Harmon$CHILD5, useNA="ifany")


# Variable:CIGDAY Format: CIGDAYF levels:5
Harmon$CIGDAY <- as.factor(Harmon$CIGDAY)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-5: None"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$CIGDAY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGDAY)[valid_positions] <- valid_labels
table(Harmon$CIGDAY, useNA="ifany")


# Variable:CIGDAY12 Format: CIGDAYF levels:5
Harmon$CIGDAY12 <- as.factor(Harmon$CIGDAY12)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-5: None"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$CIGDAY12)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGDAY12)[valid_positions] <- valid_labels
table(Harmon$CIGDAY12, useNA="ifany")


# Variable:CIGDAY20 Format: CIGDAY2F levels:6
Harmon$CIGDAY20 <- as.factor(Harmon$CIGDAY20)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$CIGDAY20)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGDAY20)[valid_positions] <- valid_labels
table(Harmon$CIGDAY20, useNA="ifany")


# Variable:CIGINDRS Format: CIGINDRF levels:6
Harmon$CIGINDRS <- as.factor(Harmon$CIGINDRS)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$CIGINDRS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGINDRS)[valid_positions] <- valid_labels
table(Harmon$CIGINDRS, useNA="ifany")


# Variable:CIGNOW Format: CIGNOWF levels:7
Harmon$CIGNOW <- as.factor(Harmon$CIGNOW)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Every day"  , 
                "2: Some days"  , 
                "3: Not at all" ) 
var_levels <-  levels(Harmon$CIGNOW)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGNOW)[valid_positions] <- valid_labels
table(Harmon$CIGNOW, useNA="ifany")


# Variable:CIGOTWAY Format: CIGOTWAF levels:8
Harmon$CIGOTWAY <- as.factor(Harmon$CIGOTWAY)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3  , 4 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: In a foreign country or a duty-free shop"  , 
                "2: From an Indian reservation"  , 
                "3: By mail-order, phone or internet"  , 
                "4: Some other way" ) 
var_levels <-  levels(Harmon$CIGOTWAY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGOTWAY)[valid_positions] <- valid_labels
table(Harmon$CIGOTWAY, useNA="ifany")


# Variable:CIGRCURR Format: OTPCURRF levels:8
Harmon$CIGRCURR <- as.factor(Harmon$CIGRCURR)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: Indeterminate" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Never"  , 
                "2: Current"  , 
                "3: Former" ) 
var_levels <-  levels(Harmon$CIGRCURR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGRCURR)[valid_positions] <- valid_labels
table(Harmon$CIGRCURR, useNA="ifany")


# Variable:CIGRDAY Format: OTPDAYF levels:5
Harmon$CIGRDAY <- as.factor(Harmon$CIGRDAY)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No Response" ,
                "-5: Did not use in the past 30 days"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$CIGRDAY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGRDAY)[valid_positions] <- valid_labels
table(Harmon$CIGRDAY, useNA="ifany")


# Variable:CIGREVER Format: OTPEVERF levels:7
Harmon$CIGREVER <- as.factor(Harmon$CIGREVER)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$CIGREVER)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGREVER)[valid_positions] <- valid_labels
table(Harmon$CIGREVER, useNA="ifany")


# Variable:CIGRFLVR Format: OTPFLVF levels:6
Harmon$CIGRFLVR <- as.factor(Harmon$CIGRFLVR)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$CIGRFLVR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGRFLVR)[valid_positions] <- valid_labels
table(Harmon$CIGRFLVR, useNA="ifany")


# Variable:CIGRLOTQ Format: OTPLOTQF levels:5
Harmon$CIGRLOTQ <- as.factor(Harmon$CIGRLOTQ)
all_values <- c(-99 ,-9  , -3  , -2  , -1 ) 
all_levels <- c("-99: Only used once or twice" ,
                "-9: No Response"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$CIGRLOTQ)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGRLOTQ)[valid_positions] <- valid_labels
table(Harmon$CIGRLOTQ, useNA="ifany")


# Variable:CIGRNOW Format: OTPNOWF levels:7
Harmon$CIGRNOW <- as.factor(Harmon$CIGRNOW)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$CIGRNOW)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGRNOW)[valid_positions] <- valid_labels
table(Harmon$CIGRNOW, useNA="ifany")


# Variable:CIGRNOW2 Format: OTPNOW2F levels:8
Harmon$CIGRNOW2 <- as.factor(Harmon$CIGRNOW2)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Every day"  , 
                "2: Some days"  , 
                "3: Former" ) 
var_levels <-  levels(Harmon$CIGRNOW2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGRNOW2)[valid_positions] <- valid_labels
table(Harmon$CIGRNOW2, useNA="ifany")


# Variable:CIGRSTAT Format: OTPSTATF levels:9
Harmon$CIGRSTAT <- as.factor(Harmon$CIGRSTAT)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3  , 4 ) 
all_levels <- c("-9: Indeterminate" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Never"  , 
                "2: Every day"  , 
                "3: Some days"  , 
                "4: Former" ) 
var_levels <-  levels(Harmon$CIGRSTAT)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGRSTAT)[valid_positions] <- valid_labels
table(Harmon$CIGRSTAT, useNA="ifany")


# Variable:CIGRTYPE Format: CIGRTYPF levels:7
Harmon$CIGRTYPE <- as.factor(Harmon$CIGRTYPE)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Regular"  , 
                "2: Cigarillos"  , 
                "3: Little filtered cigars" ) 
var_levels <-  levels(Harmon$CIGRTYPE)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGRTYPE)[valid_positions] <- valid_labels
table(Harmon$CIGRTYPE, useNA="ifany")


# Variable:CIGRYRS Format: OTPYRSF levels:4
Harmon$CIGRYRS <- as.factor(Harmon$CIGRYRS)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No Response" ,
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$CIGRYRS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGRYRS)[valid_positions] <- valid_labels
table(Harmon$CIGRYRS, useNA="ifany")


# Variable:CIGSTA12 Format: CIGSTA1F levels:7
Harmon$CIGSTA12 <- as.factor(Harmon$CIGSTA12)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Every day"  , 
                "2: Some days"  , 
                "3: Not at all" ) 
var_levels <-  levels(Harmon$CIGSTA12)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGSTA12)[valid_positions] <- valid_labels
table(Harmon$CIGSTA12, useNA="ifany")


# Variable:CIGSTAT Format: CIGSTATF levels:5
Harmon$CIGSTAT <- as.factor(Harmon$CIGSTAT)
all_values <- c(-9 ,1  , 2  , 3  , 4 ) 
all_levels <- c("-9: Indeterminate" ,
                "1: Never"  , 
                "2: Every day"  , 
                "3: Some days"  , 
                "4: Former" ) 
var_levels <-  levels(Harmon$CIGSTAT)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGSTAT)[valid_positions] <- valid_labels
table(Harmon$CIGSTAT, useNA="ifany")


# Variable:CIGSTATE Format: CIGSTF levels:58
Harmon$CIGSTATE <- as.factor(Harmon$CIGSTATE)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 4  , 5  , 6  , 8  , 9  , 10  , 11  , 12  , 13  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23  , 24  , 25  , 26  , 27  , 28  , 29  , 30  , 31  , 32  , 33  , 34  , 35  , 36  , 37  , 38  , 39  , 40  , 41  , 42  , 44  , 45  , 46  , 47  , 48  , 49
 , 50  , 51  , 53  , 54  , 55  , 56  , 57  , 88  , 99 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Alabama"  , 
                "2: Alaska"  , 
                "4: Arizona"  , 
                "5: Arkansas"  , 
                "6: California"  , 
                "8: Colorado"  , 
                "9: Connecticut"  , 
                "10: Delaware"  , 
                "11: District of Columbia"  , 
                "12: Florida"  , 
                "13: Georgia"  , 
                "15: Hawaii"  , 
                "16: Idaho"  , 
                "17: Illinois"  , 
                "18: Indiana"  , 
                "19: Iowa"  , 
                "20: Kansas"  , 
                "21: Kentucky"  , 
                "22: Louisiana"  , 
                "23: Maine"  , 
                "24: Maryland"  , 
                "25: Massachusetts"  , 
                "26: Michigan"  , 
                "27: Minnesota"  , 
                "28: Mississippi"  , 
                "29: Missouri"  , 
                "30: Montana"  , 
                "31: Nebraska"  , 
                "32: Nevada"  , 
                "33: New Hampshire"  , 
                "34: New Jersey"  , 
                "35: New Mexico"  , 
                "36: New York"  , 
                "37: North Carolina"  , 
                "38: North Dakota"  , 
                "39: Ohio"  , 
                "40: Oklahoma"  , 
                "41: Oregon"  , 
                "42: Pennsylvania"  , 
                "44: Rhode Island"  , 
                "45: South Carolina"  , 
                "46: South Dakota"  , 
                "47: Tennessee"  , 
                "48: Texas"  , 
                "49: Utah"  , 
                "50: Vermont"  , 
                "51: Virginia"  , 
                "53: Washington"  , 
                "54: West Virginia"  , 
                "55: Wisconsin"  , 
                "56: Wyoming"  , 
                "57: United States (state unknown)"  , 
                "88: Not in the U.S."  , 
                "99: NA" ) 
var_levels <-  levels(Harmon$CIGSTATE)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGSTATE)[valid_positions] <- valid_labels
table(Harmon$CIGSTATE, useNA="ifany")


# Variable:CIGTYPE Format: CIGTYPEF levels:7
Harmon$CIGTYPE <- as.factor(Harmon$CIGTYPE)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Menthol"  , 
                "2: Non-menthol"  , 
                "3: No usual type" ) 
var_levels <-  levels(Harmon$CIGTYPE)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGTYPE)[valid_positions] <- valid_labels
table(Harmon$CIGTYPE, useNA="ifany")


# Variable:CIGWHERE Format: CIGWHERF levels:7
Harmon$CIGWHERE <- as.factor(Harmon$CIGWHERE)
all_values <- c(-9 ,-5  , -3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-5: Bought some other way"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: In respondent's state of residence"  , 
                "2: In some other state (including DC)" ) 
var_levels <-  levels(Harmon$CIGWHERE)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CIGWHERE)[valid_positions] <- valid_labels
table(Harmon$CIGWHERE, useNA="ifany")


# Variable:CPDD Format: CPDDF levels:4
Harmon$CPDD <- as.factor(Harmon$CPDD)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$CPDD)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CPDD)[valid_positions] <- valid_labels
table(Harmon$CPDD, useNA="ifany")


# Variable:CPDD12 Format: CPDDF levels:4
Harmon$CPDD12 <- as.factor(Harmon$CPDD12)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$CPDD12)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CPDD12)[valid_positions] <- valid_labels
table(Harmon$CPDD12, useNA="ifany")


# Variable:CPDD20 Format: CPDD20F levels:7
Harmon$CPDD20 <- as.factor(Harmon$CPDD20)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: More"  , 
                "2: Less"  , 
                "3: About 20 (one pack)" ) 
var_levels <-  levels(Harmon$CPDD20)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CPDD20)[valid_positions] <- valid_labels
table(Harmon$CPDD20, useNA="ifany")


# Variable:CPDS Format: CPDSF levels:4
Harmon$CPDS <- as.factor(Harmon$CPDS)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$CPDS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CPDS)[valid_positions] <- valid_labels
table(Harmon$CPDS, useNA="ifany")


# Variable:CPDS12 Format: CPDSF levels:4
Harmon$CPDS12 <- as.factor(Harmon$CPDS12)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$CPDS12)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CPDS12)[valid_positions] <- valid_labels
table(Harmon$CPDS12, useNA="ifany")


# Variable:Cig100 Format: YESNOF levels:6
Harmon$Cig100 <- as.factor(Harmon$Cig100)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$Cig100)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$Cig100)[valid_positions] <- valid_labels
table(Harmon$Cig100, useNA="ifany")


# Variable:CigAge Format: CIGAGEF levels:5
Harmon$CigAge <- as.factor(Harmon$CigAge)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-5: Never smoked regularly"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$CigAge)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CigAge)[valid_positions] <- valid_labels
table(Harmon$CigAge, useNA="ifany")


# Variable:CigAgeX Format: CIGAGEXF levels:4
Harmon$CigAgeX <- as.factor(Harmon$CigAgeX)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$CigAgeX)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$CigAgeX)[valid_positions] <- valid_labels
table(Harmon$CigAgeX, useNA="ifany")


# Variable:Citizen Format: CITIZENF levels:5
Harmon$Citizen <- as.factor(Harmon$Citizen)
all_values <- c(1 ,2  , 3  , 4  , 5 ) 
all_levels <- c("1: Native, Born In The United States" ,
                "2: Native, Born In Puerto Rico or U.S. Outlying Area"  , 
                "3: Native, Born Abroad Of American Parent Or Parents"  , 
                "4: Foreign Born, U.S. Citizen By Naturalization"  , 
                "5: Foreign Born, Not A Citizen Of The United States" ) 
var_levels <-  levels(Harmon$Citizen)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$Citizen)[valid_positions] <- valid_labels
table(Harmon$Citizen, useNA="ifany")


# Variable:DDSADVEV Format: DDSADVEF levels:6
Harmon$DDSADVEV <- as.factor(Harmon$DDSADVEV)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$DDSADVEV)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$DDSADVEV)[valid_positions] <- valid_labels
table(Harmon$DDSADVEV, useNA="ifany")


# Variable:DDSADVQL Format: DDSADVQF levels:6
Harmon$DDSADVQL <- as.factor(Harmon$DDSADVQL)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$DDSADVQL)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$DDSADVQL)[valid_positions] <- valid_labels
table(Harmon$DDSADVQL, useNA="ifany")


# Variable:DDSADVYR Format: DDSADVYF levels:6
Harmon$DDSADVYR <- as.factor(Harmon$DDSADVYR)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$DDSADVYR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$DDSADVYR)[valid_positions] <- valid_labels
table(Harmon$DDSADVYR, useNA="ifany")


# Variable:DDSSEEN Format: DDSSEENF levels:6
Harmon$DDSSEEN <- as.factor(Harmon$DDSSEEN)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$DDSSEEN)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$DDSSEEN)[valid_positions] <- valid_labels
table(Harmon$DDSSEEN, useNA="ifany")


# Variable:DISCNTS Format: DISCNTSF levels:6
Harmon$DISCNTS <- as.factor(Harmon$DISCNTS)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$DISCNTS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$DISCNTS)[valid_positions] <- valid_labels
table(Harmon$DISCNTS, useNA="ifany")


# Variable:DOCADVEV Format: DOCADVEF levels:6
Harmon$DOCADVEV <- as.factor(Harmon$DOCADVEV)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$DOCADVEV)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$DOCADVEV)[valid_positions] <- valid_labels
table(Harmon$DOCADVEV, useNA="ifany")


# Variable:DOCADVQL Format: DOCADVQF levels:6
Harmon$DOCADVQL <- as.factor(Harmon$DOCADVQL)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$DOCADVQL)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$DOCADVQL)[valid_positions] <- valid_labels
table(Harmon$DOCADVQL, useNA="ifany")


# Variable:DOCADVYR Format: DOCADVYF levels:6
Harmon$DOCADVYR <- as.factor(Harmon$DOCADVYR)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$DOCADVYR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$DOCADVYR)[valid_positions] <- valid_labels
table(Harmon$DOCADVYR, useNA="ifany")


# Variable:DOCSEEN Format: DOCSEENF levels:6
Harmon$DOCSEEN <- as.factor(Harmon$DOCSEEN)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$DOCSEEN)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$DOCSEEN)[valid_positions] <- valid_labels
table(Harmon$DOCSEEN, useNA="ifany")


# Variable:ECIGBRDG Format: OTPBRDGF levels:6
Harmon$ECIGBRDG <- as.factor(Harmon$ECIGBRDG)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$ECIGBRDG)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ECIGBRDG)[valid_positions] <- valid_labels
table(Harmon$ECIGBRDG, useNA="ifany")


# Variable:ECIGCURR Format: OTPCURRF levels:8
Harmon$ECIGCURR <- as.factor(Harmon$ECIGCURR)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: Indeterminate" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Never"  , 
                "2: Current"  , 
                "3: Former" ) 
var_levels <-  levels(Harmon$ECIGCURR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ECIGCURR)[valid_positions] <- valid_labels
table(Harmon$ECIGCURR, useNA="ifany")


# Variable:ECIGDAY Format: OTPDAYF levels:5
Harmon$ECIGDAY <- as.factor(Harmon$ECIGDAY)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No Response" ,
                "-5: Did not use in the past 30 days"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$ECIGDAY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ECIGDAY)[valid_positions] <- valid_labels
table(Harmon$ECIGDAY, useNA="ifany")


# Variable:ECIGEVER Format: OTPEVERF levels:7
Harmon$ECIGEVER <- as.factor(Harmon$ECIGEVER)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$ECIGEVER)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ECIGEVER)[valid_positions] <- valid_labels
table(Harmon$ECIGEVER, useNA="ifany")


# Variable:ECIGFLVR Format: OTPFLVF levels:6
Harmon$ECIGFLVR <- as.factor(Harmon$ECIGFLVR)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$ECIGFLVR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ECIGFLVR)[valid_positions] <- valid_labels
table(Harmon$ECIGFLVR, useNA="ifany")


# Variable:ECIGLOTQ Format: OTPLOTQF levels:5
Harmon$ECIGLOTQ <- as.factor(Harmon$ECIGLOTQ)
all_values <- c(-99 ,-9  , -3  , -2  , -1 ) 
all_levels <- c("-99: Only used once or twice" ,
                "-9: No Response"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$ECIGLOTQ)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ECIGLOTQ)[valid_positions] <- valid_labels
table(Harmon$ECIGLOTQ, useNA="ifany")


# Variable:ECIGNOW Format: OTPNOWF levels:7
Harmon$ECIGNOW <- as.factor(Harmon$ECIGNOW)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$ECIGNOW)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ECIGNOW)[valid_positions] <- valid_labels
table(Harmon$ECIGNOW, useNA="ifany")


# Variable:ECIGNOW2 Format: OTPNOW2F levels:8
Harmon$ECIGNOW2 <- as.factor(Harmon$ECIGNOW2)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Every day"  , 
                "2: Some days"  , 
                "3: Former" ) 
var_levels <-  levels(Harmon$ECIGNOW2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ECIGNOW2)[valid_positions] <- valid_labels
table(Harmon$ECIGNOW2, useNA="ifany")


# Variable:ECIGSTAT Format: OTPSTATF levels:9
Harmon$ECIGSTAT <- as.factor(Harmon$ECIGSTAT)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3  , 4 ) 
all_levels <- c("-9: Indeterminate" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Never"  , 
                "2: Every day"  , 
                "3: Some days"  , 
                "4: Former" ) 
var_levels <-  levels(Harmon$ECIGSTAT)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ECIGSTAT)[valid_positions] <- valid_labels
table(Harmon$ECIGSTAT, useNA="ifany")


# Variable:ECIGTOQT Format: OTPQTF levels:6
Harmon$ECIGTOQT <- as.factor(Harmon$ECIGTOQT)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$ECIGTOQT)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ECIGTOQT)[valid_positions] <- valid_labels
table(Harmon$ECIGTOQT, useNA="ifany")


# Variable:ECIGYRS Format: OTPYRSF levels:4
Harmon$ECIGYRS <- as.factor(Harmon$ECIGYRS)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No Response" ,
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$ECIGYRS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$ECIGYRS)[valid_positions] <- valid_labels
table(Harmon$ECIGYRS, useNA="ifany")


# Variable:EVSTP1DD Format: EVSTP1DF levels:6
Harmon$EVSTP1DD <- as.factor(Harmon$EVSTP1DD)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$EVSTP1DD)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$EVSTP1DD)[valid_positions] <- valid_labels
table(Harmon$EVSTP1DD, useNA="ifany")


# Variable:EVSTP1DS Format: EVSTP1DF levels:6
Harmon$EVSTP1DS <- as.factor(Harmon$EVSTP1DS)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$EVSTP1DS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$EVSTP1DS)[valid_positions] <- valid_labels
table(Harmon$EVSTP1DS, useNA="ifany")


# Variable:EVTRYQCS Format: EVTRQCF levels:6
Harmon$EVTRYQCS <- as.factor(Harmon$EVTRYQCS)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$EVTRYQCS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$EVTRYQCS)[valid_positions] <- valid_labels
table(Harmon$EVTRYQCS, useNA="ifany")


# Variable:EVTRYQD Format: EVTRYQDF levels:6
Harmon$EVTRYQD <- as.factor(Harmon$EVTRYQD)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$EVTRYQD)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$EVTRYQD)[valid_positions] <- valid_labels
table(Harmon$EVTRYQD, useNA="ifany")


# Variable:EVTRYQS Format: EVTRYQDF levels:6
Harmon$EVTRYQS <- as.factor(Harmon$EVTRYQS)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$EVTRYQS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$EVTRYQS)[valid_positions] <- valid_labels
table(Harmon$EVTRYQS, useNA="ifany")


# Variable:Edu Format: EDUF levels:16
Harmon$Edu <- as.factor(Harmon$Edu)
all_values <- c(31 ,32  , 33  , 34  , 35  , 36  , 37  , 38  , 39  , 40  , 41  , 42  , 43  , 44  , 45  , 46 ) 
all_levels <- c("31: Less Than 1st Grade" ,
                "32: 1st, 2nd, 3rd Or 4th Grade"  , 
                "33: 5th Or 6th Grade"  , 
                "34: 7th Or 8th Grade"  , 
                "35: 9th Grade"  , 
                "36: 10th Grade"  , 
                "37: 11th Grade"  , 
                "38: 12th Grade No Diploma"  , 
                "39: High School Grad-Diploma Or Equiv (Ged)"  , 
                "40: Some College But No Degree"  , 
                "41: Associate Degree-Occupational/Vocational"  , 
                "42: Associate Degree-Academic Program"  , 
                "43: Bachelor's Degree (Ex: BA, AB, BS)"  , 
                "44: Master's Degree (Ex: MA, MS, MEng, MEd, MSW)"  , 
                "45: Professional School Deg (Ex: MD, DDS, DVM)"  , 
                "46: Doctorate Degree (Ex: PhD, EdD)" ) 
var_levels <-  levels(Harmon$Edu)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$Edu)[valid_positions] <- valid_labels
table(Harmon$Edu, useNA="ifany")


# Variable:EmplStat Format: EMPLSTAF levels:10
Harmon$EmplStat <- as.factor(Harmon$EmplStat)
all_values <- c(1 ,2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10 ) 
all_levels <- c("1: Working/Employed-at work" ,
                "2: With job, not at work/Employed-absent"  , 
                "3: Unemployed-on layoff"  , 
                "4: Unemployed-looking for work"  , 
                "5: NILF-working w/o pay <15 hrs Temp. absent for w/o pay job (1992-93 only)"  , 
                "6: NILF-unavailable (1992-93 only)"  , 
                "7: Other NILF (1992-93 only)"  , 
                "8: NILF-Retired (1995 and later)"  , 
                "9: NILF-Disabled (1995 and later)"  , 
                "10: NILF-Other (1995 and later)" ) 
var_levels <-  levels(Harmon$EmplStat)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$EmplStat)[valid_positions] <- valid_labels
table(Harmon$EmplStat, useNA="ifany")


# Variable:FIPS Format: FIPSF levels:51
Harmon$FIPS <- as.factor(Harmon$FIPS)
all_values <- c(1 ,2  , 4  , 5  , 6  , 8  , 9  , 10  , 11  , 12  , 13  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23  , 24  , 25  , 26  , 27  , 28  , 29  , 30  , 31  , 32  , 33  , 34  , 35  , 36  , 37  , 38  , 39  , 40  , 41  , 42  , 44  , 45  , 46  , 47  , 48  , 49  , 50  , 51  , 53  , 54
 , 55  , 56 ) 
all_levels <- c("1: Alabama" ,
                "2: Alaska"  , 
                "4: Arizona"  , 
                "5: Arkansas"  , 
                "6: California"  , 
                "8: Colorado"  , 
                "9: Connecticut"  , 
                "10: Delaware"  , 
                "11: District of Columbia"  , 
                "12: Florida"  , 
                "13: Georgia"  , 
                "15: Hawaii"  , 
                "16: Idaho"  , 
                "17: Illinois"  , 
                "18: Indiana"  , 
                "19: Iowa"  , 
                "20: Kansas"  , 
                "21: Kentucky"  , 
                "22: Louisiana"  , 
                "23: Maine"  , 
                "24: Maryland"  , 
                "25: Massachusetts"  , 
                "26: Michigan"  , 
                "27: Minnesota"  , 
                "28: Mississippi"  , 
                "29: Missouri"  , 
                "30: Montana"  , 
                "31: Nebraska"  , 
                "32: Nevada"  , 
                "33: New Hampshire"  , 
                "34: New Jersey"  , 
                "35: New Mexico"  , 
                "36: New York"  , 
                "37: North Carolina"  , 
                "38: North Dakota"  , 
                "39: Ohio"  , 
                "40: Oklahoma"  , 
                "41: Oregon"  , 
                "42: Pennsylvania"  , 
                "44: Rhode Island"  , 
                "45: South Carolina"  , 
                "46: South Dakota"  , 
                "47: Tennessee"  , 
                "48: Texas"  , 
                "49: Utah"  , 
                "50: Vermont"  , 
                "51: Virginia"  , 
                "53: Washington"  , 
                "54: West Virginia"  , 
                "55: Wisconsin"  , 
                "56: Wyoming" ) 
var_levels <-  levels(Harmon$FIPS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FIPS)[valid_positions] <- valid_labels
table(Harmon$FIPS, useNA="ifany")


# Variable:FMCGST12 Format: FMCGST1F levels:7
Harmon$FMCGST12 <- as.factor(Harmon$FMCGST12)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Every day"  , 
                "2: Some days"  , 
                "3: Not at all" ) 
var_levels <-  levels(Harmon$FMCGST12)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMCGST12)[valid_positions] <- valid_labels
table(Harmon$FMCGST12, useNA="ifany")


# Variable:FMCIGD12 Format: FMCIGD1F levels:5
Harmon$FMCIGD12 <- as.factor(Harmon$FMCIGD12)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-5: None"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$FMCIGD12)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMCIGD12)[valid_positions] <- valid_labels
table(Harmon$FMCIGD12, useNA="ifany")


# Variable:FMCPDD12 Format: FMCPDD1F levels:4
Harmon$FMCPDD12 <- as.factor(Harmon$FMCPDD12)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$FMCPDD12)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMCPDD12)[valid_positions] <- valid_labels
table(Harmon$FMCPDD12, useNA="ifany")


# Variable:FMCPDS12 Format: FMCPDS1F levels:4
Harmon$FMCPDS12 <- as.factor(Harmon$FMCPDS12)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$FMCPDS12)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMCPDS12)[valid_positions] <- valid_labels
table(Harmon$FMCPDS12, useNA="ifany")


# Variable:FMDOCADV Format: FMDOCADF levels:6
Harmon$FMDOCADV <- as.factor(Harmon$FMDOCADV)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMDOCADV)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMDOCADV)[valid_positions] <- valid_labels
table(Harmon$FMDOCADV, useNA="ifany")


# Variable:FMDOCSEE Format: FMDOCSEF levels:6
Harmon$FMDOCSEE <- as.factor(Harmon$FMDOCSEE)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMDOCSEE)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMDOCSEE)[valid_positions] <- valid_labels
table(Harmon$FMDOCSEE, useNA="ifany")


# Variable:FMECIGBR Format: OTPBRDGF levels:6
Harmon$FMECIGBR <- as.factor(Harmon$FMECIGBR)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMECIGBR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMECIGBR)[valid_positions] <- valid_labels
table(Harmon$FMECIGBR, useNA="ifany")


# Variable:FMECIGQT Format: OTPQTF levels:6
Harmon$FMECIGQT <- as.factor(Harmon$FMECIGQT)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMECIGQT)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMECIGQT)[valid_positions] <- valid_labels
table(Harmon$FMECIGQT, useNA="ifany")


# Variable:FMEVRCIG Format: FMEVRCIF levels:4
Harmon$FMEVRCIG <- as.factor(Harmon$FMEVRCIG)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$FMEVRCIG)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMEVRCIG)[valid_positions] <- valid_labels
table(Harmon$FMEVRCIG, useNA="ifany")


# Variable:FMEVRDLY Format: FMEVRDLF levels:6
Harmon$FMEVRDLY <- as.factor(Harmon$FMEVRDLY)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMEVRDLY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMEVRDLY)[valid_positions] <- valid_labels
table(Harmon$FMEVRDLY, useNA="ifany")


# Variable:FMLOTQT Format: FMLOTQTF levels:4
Harmon$FMLOTQT <- as.factor(Harmon$FMLOTQT)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$FMLOTQT)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMLOTQT)[valid_positions] <- valid_labels
table(Harmon$FMLOTQT, useNA="ifany")


# Variable:FMLOTQTC Format: FMLOTQCF levels:6
Harmon$FMLOTQTC <- as.factor(Harmon$FMLOTQTC)
all_values <- c(-9 ,-1  , 1  , 2  , 3  , 4 ) 
all_levels <- c("-9: Indeterminant" ,
                "-1: Not in universe"  , 
                "1: <= 1 year"  , 
                "2: > 1 year - <= 3 years"  , 
                "2: > 3 years - <= 5 years"  , 
                "2: > 5 years" ) 
var_levels <-  levels(Harmon$FMLOTQTC)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMLOTQTC)[valid_positions] <- valid_labels
table(Harmon$FMLOTQTC, useNA="ifany")


# Variable:FMMNTHGP Format: FMMNTHGF levels:10
Harmon$FMMNTHGP <- as.factor(Harmon$FMMNTHGP)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3  , 4  , 5 ) 
all_levels <- c("-9: No response" ,
                "-8: Not applicable due to instrument errror"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: All or nearly all the years you have smoked"  , 
                "2: Most of the years you have smoked"  , 
                "3: Half of the years you have smoked"  , 
                "4: Less than half of the years you have smoked"  , 
                "5: Less than one year (if volunteered)" ) 
var_levels <-  levels(Harmon$FMMNTHGP)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMMNTHGP)[valid_positions] <- valid_labels
table(Harmon$FMMNTHGP, useNA="ifany")


# Variable:FMMNTHRG Format: FMMNTHRF levels:7
Harmon$FMMNTHRG <- as.factor(Harmon$FMMNTHRG)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-8: Not applicable due to instrument errror"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMMNTHRG)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMMNTHRG)[valid_positions] <- valid_labels
table(Harmon$FMMNTHRG, useNA="ifany")


# Variable:FMMNTHUB Format: FMMNTHUF levels:8
Harmon$FMMNTHUB <- as.factor(Harmon$FMMNTHUB)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-8: Not applicable due to instrument errror"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Menthol"  , 
                "2: Non-menthol"  , 
                "3: No usual type" ) 
var_levels <-  levels(Harmon$FMMNTHUB)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMMNTHUB)[valid_positions] <- valid_labels
table(Harmon$FMMNTHUB, useNA="ifany")


# Variable:FMQHLP7A Format: FMQHLP7F levels:7
Harmon$FMQHLP7A <- as.factor(Harmon$FMQHLP7A)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Acupuncture"  , 
                "2: Hypnosis"  , 
                "3: Both" ) 
var_levels <-  levels(Harmon$FMQHLP7A)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQHLP7A)[valid_positions] <- valid_labels
table(Harmon$FMQHLP7A, useNA="ifany")


# Variable:FMQPTN4A Format: PYQPTN4F levels:6
Harmon$FMQPTN4A <- as.factor(Harmon$FMQPTN4A)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQPTN4A)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQPTN4A)[valid_positions] <- valid_labels
table(Harmon$FMQPTN4A, useNA="ifany")


# Variable:FMQTHLP1 Format: FMQTHLPF levels:6
Harmon$FMQTHLP1 <- as.factor(Harmon$FMQTHLP1)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQTHLP1)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQTHLP1)[valid_positions] <- valid_labels
table(Harmon$FMQTHLP1, useNA="ifany")


# Variable:FMQTHLP2 Format: FMQTHLPF levels:6
Harmon$FMQTHLP2 <- as.factor(Harmon$FMQTHLP2)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQTHLP2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQTHLP2)[valid_positions] <- valid_labels
table(Harmon$FMQTHLP2, useNA="ifany")


# Variable:FMQTHLP3 Format: FMQTHLPF levels:6
Harmon$FMQTHLP3 <- as.factor(Harmon$FMQTHLP3)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQTHLP3)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQTHLP3)[valid_positions] <- valid_labels
table(Harmon$FMQTHLP3, useNA="ifany")


# Variable:FMQTHLP4 Format: FMQTHLPF levels:6
Harmon$FMQTHLP4 <- as.factor(Harmon$FMQTHLP4)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQTHLP4)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQTHLP4)[valid_positions] <- valid_labels
table(Harmon$FMQTHLP4, useNA="ifany")


# Variable:FMQTHLP5 Format: FMQTHLPF levels:6
Harmon$FMQTHLP5 <- as.factor(Harmon$FMQTHLP5)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQTHLP5)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQTHLP5)[valid_positions] <- valid_labels
table(Harmon$FMQTHLP5, useNA="ifany")


# Variable:FMQTHLP6 Format: FMQTHLPF levels:6
Harmon$FMQTHLP6 <- as.factor(Harmon$FMQTHLP6)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQTHLP6)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQTHLP6)[valid_positions] <- valid_labels
table(Harmon$FMQTHLP6, useNA="ifany")


# Variable:FMQTHLP7 Format: FMQTHLPF levels:6
Harmon$FMQTHLP7 <- as.factor(Harmon$FMQTHLP7)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQTHLP7)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQTHLP7)[valid_positions] <- valid_labels
table(Harmon$FMQTHLP7, useNA="ifany")


# Variable:FMQTNRT1 Format: FMQTNRTF levels:6
Harmon$FMQTNRT1 <- as.factor(Harmon$FMQTNRT1)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQTNRT1)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQTNRT1)[valid_positions] <- valid_labels
table(Harmon$FMQTNRT1, useNA="ifany")


# Variable:FMQTNRT2 Format: FMQTNRTF levels:6
Harmon$FMQTNRT2 <- as.factor(Harmon$FMQTNRT2)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQTNRT2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQTNRT2)[valid_positions] <- valid_labels
table(Harmon$FMQTNRT2, useNA="ifany")


# Variable:FMQTNRT3 Format: FMQTNRTF levels:6
Harmon$FMQTNRT3 <- as.factor(Harmon$FMQTNRT3)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQTNRT3)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQTNRT3)[valid_positions] <- valid_labels
table(Harmon$FMQTNRT3, useNA="ifany")


# Variable:FMQTNRT4 Format: FMQTNRTF levels:6
Harmon$FMQTNRT4 <- as.factor(Harmon$FMQTNRT4)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQTNRT4)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQTNRT4)[valid_positions] <- valid_labels
table(Harmon$FMQTNRT4, useNA="ifany")


# Variable:FMQTPTN1 Format: PYQTPTNF levels:6
Harmon$FMQTPTN1 <- as.factor(Harmon$FMQTPTN1)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQTPTN1)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQTPTN1)[valid_positions] <- valid_labels
table(Harmon$FMQTPTN1, useNA="ifany")


# Variable:FMQTPTN2 Format: PYQTPTNF levels:6
Harmon$FMQTPTN2 <- as.factor(Harmon$FMQTPTN2)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQTPTN2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQTPTN2)[valid_positions] <- valid_labels
table(Harmon$FMQTPTN2, useNA="ifany")


# Variable:FMQTPTN3 Format: PYQTPTNF levels:6
Harmon$FMQTPTN3 <- as.factor(Harmon$FMQTPTN3)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQTPTN3)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQTPTN3)[valid_positions] <- valid_labels
table(Harmon$FMQTPTN3, useNA="ifany")


# Variable:FMQTPTN4 Format: PYQTPTNF levels:6
Harmon$FMQTPTN4 <- as.factor(Harmon$FMQTPTN4)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQTPTN4)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQTPTN4)[valid_positions] <- valid_labels
table(Harmon$FMQTPTN4, useNA="ifany")


# Variable:FMQTPTN5 Format: PYQTPTNF levels:6
Harmon$FMQTPTN5 <- as.factor(Harmon$FMQTPTN5)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$FMQTPTN5)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMQTPTN5)[valid_positions] <- valid_labels
table(Harmon$FMQTPTN5, useNA="ifany")


# Variable:FMTTFC Format: FMTTFCF levels:5
Harmon$FMTTFC <- as.factor(Harmon$FMTTFC)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-5: Varies"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$FMTTFC)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMTTFC)[valid_positions] <- valid_labels
table(Harmon$FMTTFC, useNA="ifany")


# Variable:FMTTFC30 Format: FMTTFC3F levels:7
Harmon$FMTTFC30 <- as.factor(Harmon$FMTTFC30)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No"  , 
                "3: Varies" ) 
var_levels <-  levels(Harmon$FMTTFC30)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMTTFC30)[valid_positions] <- valid_labels
table(Harmon$FMTTFC30, useNA="ifany")


# Variable:FMTTFO30 Format: FMTTFO3F levels:8
Harmon$FMTTFO30 <- as.factor(Harmon$FMTTFO30)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-8: Not applicable due to instrument errror"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No"  , 
                "3: Varies" ) 
var_levels <-  levels(Harmon$FMTTFO30)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMTTFO30)[valid_positions] <- valid_labels
table(Harmon$FMTTFO30, useNA="ifany")


# Variable:FMTTFOTP Format: FMTTFOTF levels:6
Harmon$FMTTFOTP <- as.factor(Harmon$FMTTFOTP)
all_values <- c(-9 ,-8  , -5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-8: Not applicable due to instrument errror"  , 
                "-5: Varies"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$FMTTFOTP)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMTTFOTP)[valid_positions] <- valid_labels
table(Harmon$FMTTFOTP, useNA="ifany")


# Variable:FMYRSDLY Format: FMYRSDLF levels:4
Harmon$FMYRSDLY <- as.factor(Harmon$FMYRSDLY)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$FMYRSDLY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMYRSDLY)[valid_positions] <- valid_labels
table(Harmon$FMYRSDLY, useNA="ifany")


# Variable:FMYRSMKC Format: FMYRSMCF levels:5
Harmon$FMYRSMKC <- as.factor(Harmon$FMYRSMKC)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-5: None or less than 1 year"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$FMYRSMKC)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMYRSMKC)[valid_positions] <- valid_labels
table(Harmon$FMYRSMKC, useNA="ifany")


# Variable:FMYRSMKG Format: FMYRSMGF levels:9
Harmon$FMYRSMKG <- as.factor(Harmon$FMYRSMKG)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3  , 4  , 5 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: All or nearly all the years you have smoked"  , 
                "2: Most of the years you have smoked"  , 
                "3: Half of the years you have smoked"  , 
                "4: Less than half of the years you have smoked"  , 
                "5: Less than one year (if volunteered)" ) 
var_levels <-  levels(Harmon$FMYRSMKG)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FMYRSMKG)[valid_positions] <- valid_labels
table(Harmon$FMYRSMKG, useNA="ifany")


# Variable:FamInc Format: FAMINCF levels:18
Harmon$FamInc <- as.factor(Harmon$FamInc)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Less Than $5,000"  , 
                "2: 5,000 to 7,499"  , 
                "3: 7,500 to 9,999"  , 
                "4: 10,000 to 12,499"  , 
                "5: 12,500 to 14,999"  , 
                "6: 15,000 to 19,999"  , 
                "7: 20,000 to 24,999"  , 
                "8: 25,000 to 29,999"  , 
                "9: 30,000 to 34,999"  , 
                "10: 35,000 to 39,999"  , 
                "11: 40,000 to 49,999"  , 
                "12: 50,000 to 59,999"  , 
                "13: 60,000 to 74,999"  , 
                "14: 75,000 or More" ) 
var_levels <-  levels(Harmon$FamInc)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$FamInc)[valid_positions] <- valid_labels
table(Harmon$FamInc, useNA="ifany")


# Variable:HMOwnRnt Format: HMOWNRNF levels:3
Harmon$HMOwnRnt <- as.factor(Harmon$HMOwnRnt)
all_values <- c(1 ,2  , 3 ) 
all_levels <- c("1: Owned or being bought by a household member" ,
                "2: Rented for cash"  , 
                "3: Occupied without payment of cash rent" ) 
var_levels <-  levels(Harmon$HMOwnRnt)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$HMOwnRnt)[valid_positions] <- valid_labels
table(Harmon$HMOwnRnt, useNA="ifany")


# Variable:HMSMKPOL Format: HMSMKPOF levels:7
Harmon$HMSMKPOL <- as.factor(Harmon$HMSMKPOL)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: No one is allowed to smoke anywhere"  , 
                "2: Smoking is allowed in some places or at some times"  , 
                "3: Smoking is allowed anywhere" ) 
var_levels <-  levels(Harmon$HMSMKPOL)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$HMSMKPOL)[valid_positions] <- valid_labels
table(Harmon$HMSMKPOL, useNA="ifany")


# Variable:HOOKCURR Format: OTPCURRF levels:8
Harmon$HOOKCURR <- as.factor(Harmon$HOOKCURR)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: Indeterminate" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Never"  , 
                "2: Current"  , 
                "3: Former" ) 
var_levels <-  levels(Harmon$HOOKCURR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$HOOKCURR)[valid_positions] <- valid_labels
table(Harmon$HOOKCURR, useNA="ifany")


# Variable:HOOKDAY Format: OTPDAYF levels:5
Harmon$HOOKDAY <- as.factor(Harmon$HOOKDAY)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No Response" ,
                "-5: Did not use in the past 30 days"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$HOOKDAY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$HOOKDAY)[valid_positions] <- valid_labels
table(Harmon$HOOKDAY, useNA="ifany")


# Variable:HOOKEVER Format: OTPEVERF levels:7
Harmon$HOOKEVER <- as.factor(Harmon$HOOKEVER)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$HOOKEVER)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$HOOKEVER)[valid_positions] <- valid_labels
table(Harmon$HOOKEVER, useNA="ifany")


# Variable:HOOKFLVR Format: OTPFLVF levels:6
Harmon$HOOKFLVR <- as.factor(Harmon$HOOKFLVR)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$HOOKFLVR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$HOOKFLVR)[valid_positions] <- valid_labels
table(Harmon$HOOKFLVR, useNA="ifany")


# Variable:HOOKLOTQ Format: OTPLOTQF levels:5
Harmon$HOOKLOTQ <- as.factor(Harmon$HOOKLOTQ)
all_values <- c(-99 ,-9  , -3  , -2  , -1 ) 
all_levels <- c("-99: Only used once or twice" ,
                "-9: No Response"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$HOOKLOTQ)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$HOOKLOTQ)[valid_positions] <- valid_labels
table(Harmon$HOOKLOTQ, useNA="ifany")


# Variable:HOOKNOW Format: OTPNOWF levels:7
Harmon$HOOKNOW <- as.factor(Harmon$HOOKNOW)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$HOOKNOW)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$HOOKNOW)[valid_positions] <- valid_labels
table(Harmon$HOOKNOW, useNA="ifany")


# Variable:HOOKNOW2 Format: OTPNOW2F levels:8
Harmon$HOOKNOW2 <- as.factor(Harmon$HOOKNOW2)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Every day"  , 
                "2: Some days"  , 
                "3: Former" ) 
var_levels <-  levels(Harmon$HOOKNOW2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$HOOKNOW2)[valid_positions] <- valid_labels
table(Harmon$HOOKNOW2, useNA="ifany")


# Variable:HOOKSTAT Format: OTPSTATF levels:9
Harmon$HOOKSTAT <- as.factor(Harmon$HOOKSTAT)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3  , 4 ) 
all_levels <- c("-9: Indeterminate" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Never"  , 
                "2: Every day"  , 
                "3: Some days"  , 
                "4: Former" ) 
var_levels <-  levels(Harmon$HOOKSTAT)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$HOOKSTAT)[valid_positions] <- valid_labels
table(Harmon$HOOKSTAT, useNA="ifany")


# Variable:HOOKYRS Format: OTPYRSF levels:4
Harmon$HOOKYRS <- as.factor(Harmon$HOOKYRS)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No Response" ,
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$HOOKYRS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$HOOKYRS)[valid_positions] <- valid_labels
table(Harmon$HOOKYRS, useNA="ifany")


# Variable:Hispan Format: HISPANF levels:2
Harmon$Hispan <- as.factor(Harmon$Hispan)
all_values <- c(1 ,2 ) 
all_levels <- c("1: Hispanic" ,
                "2: non-Hispanic" ) 
var_levels <-  levels(Harmon$Hispan)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$Hispan)[valid_positions] <- valid_labels
table(Harmon$Hispan, useNA="ifany")


# Variable:IND1DT03 Format: INDDT03F levels:53
Harmon$IND1DT03 <- as.factor(Harmon$IND1DT03)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23  , 24  , 25  , 26  , 27  , 28  , 29  , 30  , 31  , 32  , 33  , 34  , 35  , 36  , 37  , 38  , 39  , 40  , 41  , 42  , 43  , 44  , 45  , 46  , 47  , 48  , 
49  , 50  , 51  , 52 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Agriculture"  , 
                "2: Forestry, logging, fishing, hunting, and trapping"  , 
                "3: Mining"  , 
                "4: Construction"  , 
                "5: Nonmetallic mineral product manufacturing"  , 
                "6: Primary metals and fabricated metal products"  , 
                "7: Machinery  manufacturing"  , 
                "8: Computer and electronic product manufacturing"  , 
                "9: Electrical equipment, appliance manufacturing"  , 
                "10: Transportation equipment manufacturing"  , 
                "11: Wood products"  , 
                "12: Furniture and fixtures manufacturing"  , 
                "13: Miscellaneous and not specified manufacturing"  , 
                "14: Food manufacturing"  , 
                "15: Beverage and tobacco products"  , 
                "16: Textile, apparel, and leather manufacturing"  , 
                "17: Paper and printing"  , 
                "18: Petroleum and coal products manufacturing"  , 
                "19: Chemical manufacturing"  , 
                "20: Plastics and rubber products"  , 
                "21: Wholesale trade"  , 
                "22: Retail trade"  , 
                "23: Transportation and warehousing"  , 
                "24: Utilities"  , 
                "25: Publishing industries (except internet)"  , 
                "26: Motion picture and sound recording industries"  , 
                "27: Broadcasting (except internet)"  , 
                "28: Internet publishing and broadcasting"  , 
                "29: Telecommunications"  , 
                "30: Internet service providers and data processing services"  , 
                "31: Other information services"  , 
                "32: Finance"  , 
                "33: Insurance"  , 
                "34: Real estate"  , 
                "35: Rental and leasing services"  , 
                "36: Professional and technical services"  , 
                "37: Management of companies and enterprises"  , 
                "38: Administrative and support services"  , 
                "39: Waste management and remediation services"  , 
                "40: Educational services"  , 
                "41: Hospitals"  , 
                "42: Health care services, except hospitals"  , 
                "43: Social assistance"  , 
                "44: Arts, entertainment, and recreation"  , 
                "45: Accommodation"  , 
                "46: Food services and drinking places"  , 
                "47: Repair and maintenance"  , 
                "48: Personal and laundry services"  , 
                "49: Membership associations and organizations"  , 
                "50: Private households"  , 
                "51: Public administration"  , 
                "52: Armed forces" ) 
var_levels <-  levels(Harmon$IND1DT03)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$IND1DT03)[valid_positions] <- valid_labels
table(Harmon$IND1DT03, useNA="ifany")


# Variable:IND1DT95 Format: INDDT95F levels:53
Harmon$IND1DT95 <- as.factor(Harmon$IND1DT95)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23  , 24  , 25  , 26  , 27  , 28  , 29  , 30  , 31  , 32  , 33  , 34  , 35  , 36  , 37  , 38  , 39  , 40  , 41  , 42  , 43  , 44  , 45  , 46  , 47  , 48  , 
49  , 50  , 51  , 52 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Goods producing-agricultural services"  , 
                "2: Goods producing-other agricultural"  , 
                "3: Mining"  , 
                "4: Construction"  , 
                "5: Mfg-lumber & wood prods, ex furniture"  , 
                "6: Mfg-furniture & fixtures"  , 
                "7: Mfg-stone, clay, concrete, glass prods"  , 
                "8: Mfg-primary metals"  , 
                "9: Mfg-fabricated metals"  , 
                "10: Mfg-not specified metal industries"  , 
                "11: Mfg-machinery, ex electrical"  , 
                "12: Mfg-electrical machinery, equip supplies"  , 
                "13: Mfg-motor vehicles & equip"  , 
                "14: Mfg-aircraft & parts"  , 
                "15: Mfg-other transportation equipment"  , 
                "16: Mfg-professional & photo equip, watches"  , 
                "17: Mfg-toys, amusement & sporting goods"  , 
                "18: Mfg-misc & nec mfg industries"  , 
                "19: Mfg-food & kindred prods"  , 
                "20: Mfg-tobacco prods"  , 
                "21: Mfg-textile mill prods"  , 
                "22: Mfg-apparel & other finished textile pr"  , 
                "23: Mfg-paper & allied products"  , 
                "24: Mfg-printing, publishing & allied inds"  , 
                "25: Mfg-chemicals & allied prods"  , 
                "26: Mfg-petroleum & coal prods"  , 
                "27: Mfg-rubber & misc plastic prods"  , 
                "28: Mfg-leather & leather prods"  , 
                "29: Transportation"  , 
                "30: Communications"  , 
                "31: Utilities & sanitary services"  , 
                "32: Wholesale trade"  , 
                "33: Eating and drinking places"  , 
                "34: Other retail trade"  , 
                "35: Banking and other finance"  , 
                "36: Insurance and real estate"  , 
                "37: Private household services"  , 
                "38: Business services"  , 
                "39: Automobile and repair services"  , 
                "40: Personal serv exc private households"  , 
                "41: Entertainment & recreation services"  , 
                "42: Hospitals"  , 
                "43: Health services, exc. hospitals"  , 
                "44: Educational services"  , 
                "45: Social services"  , 
                "46: Other professional services"  , 
                "47: Forestry & fisheries"  , 
                "48: Justice, public order & safety"  , 
                "49: Admin of human resource programs"  , 
                "50: National security & internal affairs"  , 
                "51: Other public administration"  , 
                "52: Armed forces" ) 
var_levels <-  levels(Harmon$IND1DT95)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$IND1DT95)[valid_positions] <- valid_labels
table(Harmon$IND1DT95, useNA="ifany")


# Variable:IND1MJ03 Format: INDMJ03F levels:15
Harmon$IND1MJ03 <- as.factor(Harmon$IND1MJ03)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Agriculture, forestry, fishing, and hunting"  , 
                "2: Mining"  , 
                "3: Construction"  , 
                "4: Manufacturing"  , 
                "5: Wholesale and retail trade"  , 
                "6: Transportation and utilities"  , 
                "7: Information"  , 
                "8: Financial activities"  , 
                "9: Professional and business services"  , 
                "10: Educational and health services"  , 
                "11: Leisure and hospitality"  , 
                "12: Other services"  , 
                "13: Public administration"  , 
                "14 Armed Forces" ) 
var_levels <-  levels(Harmon$IND1MJ03)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$IND1MJ03)[valid_positions] <- valid_labels
table(Harmon$IND1MJ03, useNA="ifany")


# Variable:IND1MJ95 Format: INDMJ95F levels:24
Harmon$IND1MJ95 <- as.factor(Harmon$IND1MJ95)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Agriculture"  , 
                "2: Mining"  , 
                "3: Construction"  , 
                "4: Manufacturing - durable goods"  , 
                "5: Manufacturing - non-durable goods"  , 
                "6: Transportation"  , 
                "7: Communications"  , 
                "8: Utilities and sanitary services"  , 
                "9: Wholesale trade"  , 
                "10: Retail trade"  , 
                "11: Finance, insurance, and real estate"  , 
                "12: Private households"  , 
                "13: Business, auto and repair services"  , 
                "14: Personal services, exc. private hhlds"  , 
                "15: Entertainment and recreation services"  , 
                "16: Hospitals"  , 
                "17: Medical services, exc. hospitals"  , 
                "18: Educational services"  , 
                "19: Social services"  , 
                "20: Other professional services"  , 
                "21: Forestry and fisheries"  , 
                "22: Public administration"  , 
                "23: Armed forces" ) 
var_levels <-  levels(Harmon$IND1MJ95)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$IND1MJ95)[valid_positions] <- valid_labels
table(Harmon$IND1MJ95, useNA="ifany")


# Variable:IND2DT03 Format: INDDT03F levels:53
Harmon$IND2DT03 <- as.factor(Harmon$IND2DT03)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23  , 24  , 25  , 26  , 27  , 28  , 29  , 30  , 31  , 32  , 33  , 34  , 35  , 36  , 37  , 38  , 39  , 40  , 41  , 42  , 43  , 44  , 45  , 46  , 47  , 48  , 
49  , 50  , 51  , 52 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Agriculture"  , 
                "2: Forestry, logging, fishing, hunting, and trapping"  , 
                "3: Mining"  , 
                "4: Construction"  , 
                "5: Nonmetallic mineral product manufacturing"  , 
                "6: Primary metals and fabricated metal products"  , 
                "7: Machinery  manufacturing"  , 
                "8: Computer and electronic product manufacturing"  , 
                "9: Electrical equipment, appliance manufacturing"  , 
                "10: Transportation equipment manufacturing"  , 
                "11: Wood products"  , 
                "12: Furniture and fixtures manufacturing"  , 
                "13: Miscellaneous and not specified manufacturing"  , 
                "14: Food manufacturing"  , 
                "15: Beverage and tobacco products"  , 
                "16: Textile, apparel, and leather manufacturing"  , 
                "17: Paper and printing"  , 
                "18: Petroleum and coal products manufacturing"  , 
                "19: Chemical manufacturing"  , 
                "20: Plastics and rubber products"  , 
                "21: Wholesale trade"  , 
                "22: Retail trade"  , 
                "23: Transportation and warehousing"  , 
                "24: Utilities"  , 
                "25: Publishing industries (except internet)"  , 
                "26: Motion picture and sound recording industries"  , 
                "27: Broadcasting (except internet)"  , 
                "28: Internet publishing and broadcasting"  , 
                "29: Telecommunications"  , 
                "30: Internet service providers and data processing services"  , 
                "31: Other information services"  , 
                "32: Finance"  , 
                "33: Insurance"  , 
                "34: Real estate"  , 
                "35: Rental and leasing services"  , 
                "36: Professional and technical services"  , 
                "37: Management of companies and enterprises"  , 
                "38: Administrative and support services"  , 
                "39: Waste management and remediation services"  , 
                "40: Educational services"  , 
                "41: Hospitals"  , 
                "42: Health care services, except hospitals"  , 
                "43: Social assistance"  , 
                "44: Arts, entertainment, and recreation"  , 
                "45: Accommodation"  , 
                "46: Food services and drinking places"  , 
                "47: Repair and maintenance"  , 
                "48: Personal and laundry services"  , 
                "49: Membership associations and organizations"  , 
                "50: Private households"  , 
                "51: Public administration"  , 
                "52: Armed forces" ) 
var_levels <-  levels(Harmon$IND2DT03)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$IND2DT03)[valid_positions] <- valid_labels
table(Harmon$IND2DT03, useNA="ifany")


# Variable:IND2DT95 Format: INDDT95F levels:53
Harmon$IND2DT95 <- as.factor(Harmon$IND2DT95)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23  , 24  , 25  , 26  , 27  , 28  , 29  , 30  , 31  , 32  , 33  , 34  , 35  , 36  , 37  , 38  , 39  , 40  , 41  , 42  , 43  , 44  , 45  , 46  , 47  , 48  , 
49  , 50  , 51  , 52 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Goods producing-agricultural services"  , 
                "2: Goods producing-other agricultural"  , 
                "3: Mining"  , 
                "4: Construction"  , 
                "5: Mfg-lumber & wood prods, ex furniture"  , 
                "6: Mfg-furniture & fixtures"  , 
                "7: Mfg-stone, clay, concrete, glass prods"  , 
                "8: Mfg-primary metals"  , 
                "9: Mfg-fabricated metals"  , 
                "10: Mfg-not specified metal industries"  , 
                "11: Mfg-machinery, ex electrical"  , 
                "12: Mfg-electrical machinery, equip supplies"  , 
                "13: Mfg-motor vehicles & equip"  , 
                "14: Mfg-aircraft & parts"  , 
                "15: Mfg-other transportation equipment"  , 
                "16: Mfg-professional & photo equip, watches"  , 
                "17: Mfg-toys, amusement & sporting goods"  , 
                "18: Mfg-misc & nec mfg industries"  , 
                "19: Mfg-food & kindred prods"  , 
                "20: Mfg-tobacco prods"  , 
                "21: Mfg-textile mill prods"  , 
                "22: Mfg-apparel & other finished textile pr"  , 
                "23: Mfg-paper & allied products"  , 
                "24: Mfg-printing, publishing & allied inds"  , 
                "25: Mfg-chemicals & allied prods"  , 
                "26: Mfg-petroleum & coal prods"  , 
                "27: Mfg-rubber & misc plastic prods"  , 
                "28: Mfg-leather & leather prods"  , 
                "29: Transportation"  , 
                "30: Communications"  , 
                "31: Utilities & sanitary services"  , 
                "32: Wholesale trade"  , 
                "33: Eating and drinking places"  , 
                "34: Other retail trade"  , 
                "35: Banking and other finance"  , 
                "36: Insurance and real estate"  , 
                "37: Private household services"  , 
                "38: Business services"  , 
                "39: Automobile and repair services"  , 
                "40: Personal serv exc private households"  , 
                "41: Entertainment & recreation services"  , 
                "42: Hospitals"  , 
                "43: Health services, exc. hospitals"  , 
                "44: Educational services"  , 
                "45: Social services"  , 
                "46: Other professional services"  , 
                "47: Forestry & fisheries"  , 
                "48: Justice, public order & safety"  , 
                "49: Admin of human resource programs"  , 
                "50: National security & internal affairs"  , 
                "51: Other public administration"  , 
                "52: Armed forces" ) 
var_levels <-  levels(Harmon$IND2DT95)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$IND2DT95)[valid_positions] <- valid_labels
table(Harmon$IND2DT95, useNA="ifany")


# Variable:IND2MJ03 Format: INDMJ03F levels:15
Harmon$IND2MJ03 <- as.factor(Harmon$IND2MJ03)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Agriculture, forestry, fishing, and hunting"  , 
                "2: Mining"  , 
                "3: Construction"  , 
                "4: Manufacturing"  , 
                "5: Wholesale and retail trade"  , 
                "6: Transportation and utilities"  , 
                "7: Information"  , 
                "8: Financial activities"  , 
                "9: Professional and business services"  , 
                "10: Educational and health services"  , 
                "11: Leisure and hospitality"  , 
                "12: Other services"  , 
                "13: Public administration"  , 
                "14 Armed Forces" ) 
var_levels <-  levels(Harmon$IND2MJ03)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$IND2MJ03)[valid_positions] <- valid_labels
table(Harmon$IND2MJ03, useNA="ifany")


# Variable:IND2MJ95 Format: INDMJ95F levels:24
Harmon$IND2MJ95 <- as.factor(Harmon$IND2MJ95)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Agriculture"  , 
                "2: Mining"  , 
                "3: Construction"  , 
                "4: Manufacturing - durable goods"  , 
                "5: Manufacturing - non-durable goods"  , 
                "6: Transportation"  , 
                "7: Communications"  , 
                "8: Utilities and sanitary services"  , 
                "9: Wholesale trade"  , 
                "10: Retail trade"  , 
                "11: Finance, insurance, and real estate"  , 
                "12: Private households"  , 
                "13: Business, auto and repair services"  , 
                "14: Personal services, exc. private hhlds"  , 
                "15: Entertainment and recreation services"  , 
                "16: Hospitals"  , 
                "17: Medical services, exc. hospitals"  , 
                "18: Educational services"  , 
                "19: Social services"  , 
                "20: Other professional services"  , 
                "21: Forestry and fisheries"  , 
                "22: Public administration"  , 
                "23: Armed forces" ) 
var_levels <-  levels(Harmon$IND2MJ95)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$IND2MJ95)[valid_positions] <- valid_labels
table(Harmon$IND2MJ95, useNA="ifany")


# Variable:INTQT30D Format: INTQT30F levels:6
Harmon$INTQT30D <- as.factor(Harmon$INTQT30D)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$INTQT30D)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$INTQT30D)[valid_positions] <- valid_labels
table(Harmon$INTQT30D, useNA="ifany")


# Variable:INTQT6MO Format: INTQT6MF levels:6
Harmon$INTQT6MO <- as.factor(Harmon$INTQT6MO)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$INTQT6MO)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$INTQT6MO)[valid_positions] <- valid_labels
table(Harmon$INTQT6MO, useNA="ifany")


# Variable:INTRQUIT Format: INTRQUIF levels:4
Harmon$INTRQUIT <- as.factor(Harmon$INTRQUIT)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$INTRQUIT)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$INTRQUIT)[valid_positions] <- valid_labels
table(Harmon$INTRQUIT, useNA="ifany")


# Variable:MENTHGRP Format: MENTHGRF levels:9
Harmon$MENTHGRP <- as.factor(Harmon$MENTHGRP)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3  , 4  , 5 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: All or nearly all the years you have smoked"  , 
                "2: Most of the years you have smoked"  , 
                "3: Half of the years you have smoked"  , 
                "4: Less than half of the years you have smoked"  , 
                "5: Less than one year" ) 
var_levels <-  levels(Harmon$MENTHGRP)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$MENTHGRP)[valid_positions] <- valid_labels
table(Harmon$MENTHGRP, useNA="ifany")


# Variable:MENTHOL Format: MENTHOLF levels:6
Harmon$MENTHOL <- as.factor(Harmon$MENTHOL)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$MENTHOL)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$MENTHOL)[valid_positions] <- valid_labels
table(Harmon$MENTHOL, useNA="ifany")


# Variable:MENTHREG Format: MENTHREF levels:6
Harmon$MENTHREG <- as.factor(Harmon$MENTHREG)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$MENTHREG)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$MENTHREG)[valid_positions] <- valid_labels
table(Harmon$MENTHREG, useNA="ifany")


# Variable:MUHSMPOL Format: MUHSMPOF levels:7
Harmon$MUHSMPOL <- as.factor(Harmon$MUHSMPOL)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Allowed inside all apartments and living areas"  , 
                "2: Allowed inside some apartments"  , 
                "3: Not allowed at all inside apartments" ) 
var_levels <-  levels(Harmon$MUHSMPOL)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$MUHSMPOL)[valid_positions] <- valid_labels
table(Harmon$MUHSMPOL, useNA="ifany")


# Variable:MULTJOBS Format: MULTJOBF levels:3
Harmon$MULTJOBS <- as.factor(Harmon$MULTJOBS)
all_values <- c(-1 ,1  , 2 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$MULTJOBS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$MULTJOBS)[valid_positions] <- valid_labels
table(Harmon$MULTJOBS, useNA="ifany")


# Variable:Marital Format: MARITALF levels:8
Harmon$Marital <- as.factor(Harmon$Marital)
all_values <- c(1 ,2  , 3  , 4  , 5  , 6  , 7  , 11 ) 
all_levels <- c("1: Married, civilian spouse present" ,
                "2: Married, armed forces spouse present"  , 
                "3: Married, spouse absent (exc. separated)"  , 
                "4: Widowed"  , 
                "5: Divorced"  , 
                "6: Separated"  , 
                "7: Never married"  , 
                "11: Unknown" ) 
var_levels <-  levels(Harmon$Marital)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$Marital)[valid_positions] <- valid_labels
table(Harmon$Marital, useNA="ifany")


# Variable:MetStat Format: METSTATF levels:3
Harmon$MetStat <- as.factor(Harmon$MetStat)
all_values <- c(1 ,2  , 3 ) 
all_levels <- c("1: Metropolitan" ,
                "2: Non-Metropolitan"  , 
                "3: Not Identified" ) 
var_levels <-  levels(Harmon$MetStat)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$MetStat)[valid_positions] <- valid_labels
table(Harmon$MetStat, useNA="ifany")


# Variable:Natvty Format: NATVTYF levels:174
Harmon$Natvty <- as.factor(Harmon$Natvty)
all_values <- c(57 ,60  , 66  , 69  , 73  , 78  , 96  , 100  , 102  , 103  , 104  , 105  , 106  , 108  , 109  , 110  , 116  , 117  , 118  , 119  , 120  , 126  , 127  , 128  , 129  , 130  , 132  , 134  , 136  , 137  , 138  , 139  , 140  , 141  , 142  , 147  , 148  , 149  , 150  , 151  , 152  , 154
 , 155  , 156  , 157  , 158  , 159  , 160  , 161  , 162  , 163  , 164  , 165  , 166  , 167  , 168  , 200  , 202  , 203  , 205  , 206  , 207  , 208  , 209  , 210  , 211  , 212  , 213  , 214  , 215  , 216  , 217  , 218  , 220  , 222  , 223  , 224  , 226  , 228  , 229  , 231  , 233  , 235  , 236  , 238
 , 239  , 240  , 242  , 243  , 245  , 246  , 247  , 248  , 249  , 252  , 253  , 300  , 301  , 303  , 304  , 310  , 311  , 312  , 313  , 314  , 315  , 316  , 318  , 321  , 323  , 324  , 327  , 328  , 329  , 330  , 332  , 333  , 338  , 339  , 340  , 341  , 343  , 360  , 361  , 362  , 363  , 364  , 365
 , 368  , 369  , 370  , 372  , 373  , 374  , 399  , 400  , 407  , 408  , 412  , 414  , 416  , 417  , 421  , 423  , 425  , 427  , 429  , 430  , 436  , 440  , 444  , 447  , 448  , 449  , 451  , 453  , 454  , 457  , 459  , 460  , 461  , 462  , 468  , 501  , 508  , 511  , 512  , 515  , 523  , 527  , 528
 , 529  , 555  , 998 ) 
all_levels <- c("57: United States" ,
                "60: American Samoa"  , 
                "66: Guam"  , 
                "69: Northern Marianas"  , 
                "73: Puerto Rico"  , 
                "78: U. S. Virgin Islands"  , 
                "96: Other U.S. Island Areas"  , 
                "100: Albania"  , 
                "102: Austria"  , 
                "103: Belgium"  , 
                "104: Bulgaria"  , 
                "105: Czechoslovakia"  , 
                "106: Denmark"  , 
                "108: Finland"  , 
                "109: France"  , 
                "110: Germany"  , 
                "116: Greece"  , 
                "117: Hungary"  , 
                "118: Iceland"  , 
                "119: Ireland"  , 
                "120: Italy"  , 
                "126: Netherlands"  , 
                "127: Norway"  , 
                "128: Poland"  , 
                "129: Portugal"  , 
                "130: Azores"  , 
                "132: Romania"  , 
                "134: Spain"  , 
                "136: Sweden"  , 
                "137: Switzerland"  , 
                "138: United Kingdom"  , 
                "139: England"  , 
                "140: Scotland"  , 
                "141: Wales"  , 
                "142: Northern Ireland"  , 
                "147: Yugoslavia"  , 
                "148: Czech Republic"  , 
                "149: Slovakia"  , 
                "150: Bosnia & Herzegovina"  , 
                "151: Croatia"  , 
                "152: Macedonia"  , 
                "154: Serbia"  , 
                "155: Estonia"  , 
                "156: Latvia"  , 
                "157: Lithuania"  , 
                "158: Armenia"  , 
                "159: Azerbaijan"  , 
                "160: Belarus"  , 
                "161: Georgia"  , 
                "162: Moldova"  , 
                "163: Russia"  , 
                "164: Ukraine"  , 
                "165: USSR"  , 
                "166: Europe, not specified"  , 
                "167: Kosovo"  , 
                "168: Montenegro"  , 
                "200: Afghanistan"  , 
                "202: Bangladesh"  , 
                "203: Bhutan"  , 
                "205: Myanmar (Burma)"  , 
                "206: Cambodia"  , 
                "207: China"  , 
                "208: Cyprus"  , 
                "209: Hong Kong"  , 
                "210: India"  , 
                "211: Indonesia"  , 
                "212: Iran"  , 
                "213: Iraq"  , 
                "214: Israel"  , 
                "215: Japan"  , 
                "216: Jordan"  , 
                "217: Korea/South Korea"  , 
                "218: Kazakhstan"  , 
                "220: South Korea"  , 
                "222: Kuwait"  , 
                "223: Laos"  , 
                "224: Lebanon"  , 
                "226: Malaysia"  , 
                "228: Mongolia"  , 
                "229: Nepal"  , 
                "231: Pakistan"  , 
                "233: Philippines"  , 
                "235: Saudi Arabia"  , 
                "236: Singapore"  , 
                "238: Sri Lanka"  , 
                "239: Syria"  , 
                "240: Taiwan"  , 
                "242: Thailand"  , 
                "243: Turkey"  , 
                "245: United Arab Emirates"  , 
                "246: Uzbekistan"  , 
                "247: Vietnam"  , 
                "248: Yemen"  , 
                "249: Asia, not specified"  , 
                "252: Middle East"  , 
                "253: Palestine"  , 
                "300: Bermuda"  , 
                "301: Canada"  , 
                "303: Mexico"  , 
                "304: North America"  , 
                "310: Belize"  , 
                "311: Costa Rica"  , 
                "312: El Salvador"  , 
                "313: Guatemala"  , 
                "314: Honduras"  , 
                "315: Nicaragua"  , 
                "316: Panama"  , 
                "318: Central America"  , 
                "321: Antigua and Barbuda"  , 
                "323: Bahamas"  , 
                "324: Barbados"  , 
                "327: Cuba"  , 
                "328: Dominica"  , 
                "329: Dominican Republic"  , 
                "330: Grenada"  , 
                "332: Haiti"  , 
                "333: Jamaica"  , 
                "338: St. Kitts--Nevis"  , 
                "339: St. Lucia"  , 
                "340: St. Vincent and the Grenadines"  , 
                "341: Trinidad and Tobago"  , 
                "343: West Indies, not specified"  , 
                "360: Argentina"  , 
                "361: Bolivia"  , 
                "362: Brazil"  , 
                "363: Chile"  , 
                "364: Columbia"  , 
                "365: Ecuador"  , 
                "368: Guyana"  , 
                "369: Paraguay"  , 
                "370: Peru"  , 
                "372: Uruguay"  , 
                "373: Venezuela"  , 
                "374: South America, not specified"  , 
                "399: Americas, not specified"  , 
                "400: Algeria"  , 
                "407: Cameroon"  , 
                "408: Cape Verde"  , 
                "412: Congo"  , 
                "414: Egypt"  , 
                "416: Ethiopia"  , 
                "417: Eritrea"  , 
                "421: Ghana"  , 
                "423: Guinea"  , 
                "425: Ivory Coast"  , 
                "427: Kenya"  , 
                "429: Liberia"  , 
                "430: Libya"  , 
                "436: Morocco"  , 
                "440: Nigeria"  , 
                "444: Senegal"  , 
                "447: Sierra Leone"  , 
                "448: Somalia"  , 
                "449: South Africa"  , 
                "451: Sudan"  , 
                "453: Tanzania"  , 
                "454: Togo"  , 
                "457: Uganda"  , 
                "459: Zaire"  , 
                "460: Zambia"  , 
                "461: Zimbabwe"  , 
                "462: Africa, not specified"  , 
                "468: North Africa"  , 
                "501: Australia"  , 
                "508: Fiji"  , 
                "511: Marshall Islands"  , 
                "512: Micronesia"  , 
                "515: New Zealand"  , 
                "523: Tonga"  , 
                "527: Samoa"  , 
                "528: Oceania, not specified"  , 
                "529: Pacific Islands"  , 
                "555: Elsewhere"  , 
                "998: Code '218' in 1995-2006, not listed in documentation" ) 
var_levels <-  levels(Harmon$Natvty)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$Natvty)[valid_positions] <- valid_labels
table(Harmon$Natvty, useNA="ifany")


# Variable:NatvtyF Format: NATVTYF levels:174
Harmon$NatvtyF <- as.factor(Harmon$NatvtyF)
all_values <- c(57 ,60  , 66  , 69  , 73  , 78  , 96  , 100  , 102  , 103  , 104  , 105  , 106  , 108  , 109  , 110  , 116  , 117  , 118  , 119  , 120  , 126  , 127  , 128  , 129  , 130  , 132  , 134  , 136  , 137  , 138  , 139  , 140  , 141  , 142  , 147  , 148  , 149  , 150  , 151  , 152  , 154
 , 155  , 156  , 157  , 158  , 159  , 160  , 161  , 162  , 163  , 164  , 165  , 166  , 167  , 168  , 200  , 202  , 203  , 205  , 206  , 207  , 208  , 209  , 210  , 211  , 212  , 213  , 214  , 215  , 216  , 217  , 218  , 220  , 222  , 223  , 224  , 226  , 228  , 229  , 231  , 233  , 235  , 236  , 238
 , 239  , 240  , 242  , 243  , 245  , 246  , 247  , 248  , 249  , 252  , 253  , 300  , 301  , 303  , 304  , 310  , 311  , 312  , 313  , 314  , 315  , 316  , 318  , 321  , 323  , 324  , 327  , 328  , 329  , 330  , 332  , 333  , 338  , 339  , 340  , 341  , 343  , 360  , 361  , 362  , 363  , 364  , 365
 , 368  , 369  , 370  , 372  , 373  , 374  , 399  , 400  , 407  , 408  , 412  , 414  , 416  , 417  , 421  , 423  , 425  , 427  , 429  , 430  , 436  , 440  , 444  , 447  , 448  , 449  , 451  , 453  , 454  , 457  , 459  , 460  , 461  , 462  , 468  , 501  , 508  , 511  , 512  , 515  , 523  , 527  , 528
 , 529  , 555  , 998 ) 
all_levels <- c("57: United States" ,
                "60: American Samoa"  , 
                "66: Guam"  , 
                "69: Northern Marianas"  , 
                "73: Puerto Rico"  , 
                "78: U. S. Virgin Islands"  , 
                "96: Other U.S. Island Areas"  , 
                "100: Albania"  , 
                "102: Austria"  , 
                "103: Belgium"  , 
                "104: Bulgaria"  , 
                "105: Czechoslovakia"  , 
                "106: Denmark"  , 
                "108: Finland"  , 
                "109: France"  , 
                "110: Germany"  , 
                "116: Greece"  , 
                "117: Hungary"  , 
                "118: Iceland"  , 
                "119: Ireland"  , 
                "120: Italy"  , 
                "126: Netherlands"  , 
                "127: Norway"  , 
                "128: Poland"  , 
                "129: Portugal"  , 
                "130: Azores"  , 
                "132: Romania"  , 
                "134: Spain"  , 
                "136: Sweden"  , 
                "137: Switzerland"  , 
                "138: United Kingdom"  , 
                "139: England"  , 
                "140: Scotland"  , 
                "141: Wales"  , 
                "142: Northern Ireland"  , 
                "147: Yugoslavia"  , 
                "148: Czech Republic"  , 
                "149: Slovakia"  , 
                "150: Bosnia & Herzegovina"  , 
                "151: Croatia"  , 
                "152: Macedonia"  , 
                "154: Serbia"  , 
                "155: Estonia"  , 
                "156: Latvia"  , 
                "157: Lithuania"  , 
                "158: Armenia"  , 
                "159: Azerbaijan"  , 
                "160: Belarus"  , 
                "161: Georgia"  , 
                "162: Moldova"  , 
                "163: Russia"  , 
                "164: Ukraine"  , 
                "165: USSR"  , 
                "166: Europe, not specified"  , 
                "167: Kosovo"  , 
                "168: Montenegro"  , 
                "200: Afghanistan"  , 
                "202: Bangladesh"  , 
                "203: Bhutan"  , 
                "205: Myanmar (Burma)"  , 
                "206: Cambodia"  , 
                "207: China"  , 
                "208: Cyprus"  , 
                "209: Hong Kong"  , 
                "210: India"  , 
                "211: Indonesia"  , 
                "212: Iran"  , 
                "213: Iraq"  , 
                "214: Israel"  , 
                "215: Japan"  , 
                "216: Jordan"  , 
                "217: Korea/South Korea"  , 
                "218: Kazakhstan"  , 
                "220: South Korea"  , 
                "222: Kuwait"  , 
                "223: Laos"  , 
                "224: Lebanon"  , 
                "226: Malaysia"  , 
                "228: Mongolia"  , 
                "229: Nepal"  , 
                "231: Pakistan"  , 
                "233: Philippines"  , 
                "235: Saudi Arabia"  , 
                "236: Singapore"  , 
                "238: Sri Lanka"  , 
                "239: Syria"  , 
                "240: Taiwan"  , 
                "242: Thailand"  , 
                "243: Turkey"  , 
                "245: United Arab Emirates"  , 
                "246: Uzbekistan"  , 
                "247: Vietnam"  , 
                "248: Yemen"  , 
                "249: Asia, not specified"  , 
                "252: Middle East"  , 
                "253: Palestine"  , 
                "300: Bermuda"  , 
                "301: Canada"  , 
                "303: Mexico"  , 
                "304: North America"  , 
                "310: Belize"  , 
                "311: Costa Rica"  , 
                "312: El Salvador"  , 
                "313: Guatemala"  , 
                "314: Honduras"  , 
                "315: Nicaragua"  , 
                "316: Panama"  , 
                "318: Central America"  , 
                "321: Antigua and Barbuda"  , 
                "323: Bahamas"  , 
                "324: Barbados"  , 
                "327: Cuba"  , 
                "328: Dominica"  , 
                "329: Dominican Republic"  , 
                "330: Grenada"  , 
                "332: Haiti"  , 
                "333: Jamaica"  , 
                "338: St. Kitts--Nevis"  , 
                "339: St. Lucia"  , 
                "340: St. Vincent and the Grenadines"  , 
                "341: Trinidad and Tobago"  , 
                "343: West Indies, not specified"  , 
                "360: Argentina"  , 
                "361: Bolivia"  , 
                "362: Brazil"  , 
                "363: Chile"  , 
                "364: Columbia"  , 
                "365: Ecuador"  , 
                "368: Guyana"  , 
                "369: Paraguay"  , 
                "370: Peru"  , 
                "372: Uruguay"  , 
                "373: Venezuela"  , 
                "374: South America, not specified"  , 
                "399: Americas, not specified"  , 
                "400: Algeria"  , 
                "407: Cameroon"  , 
                "408: Cape Verde"  , 
                "412: Congo"  , 
                "414: Egypt"  , 
                "416: Ethiopia"  , 
                "417: Eritrea"  , 
                "421: Ghana"  , 
                "423: Guinea"  , 
                "425: Ivory Coast"  , 
                "427: Kenya"  , 
                "429: Liberia"  , 
                "430: Libya"  , 
                "436: Morocco"  , 
                "440: Nigeria"  , 
                "444: Senegal"  , 
                "447: Sierra Leone"  , 
                "448: Somalia"  , 
                "449: South Africa"  , 
                "451: Sudan"  , 
                "453: Tanzania"  , 
                "454: Togo"  , 
                "457: Uganda"  , 
                "459: Zaire"  , 
                "460: Zambia"  , 
                "461: Zimbabwe"  , 
                "462: Africa, not specified"  , 
                "468: North Africa"  , 
                "501: Australia"  , 
                "508: Fiji"  , 
                "511: Marshall Islands"  , 
                "512: Micronesia"  , 
                "515: New Zealand"  , 
                "523: Tonga"  , 
                "527: Samoa"  , 
                "528: Oceania, not specified"  , 
                "529: Pacific Islands"  , 
                "555: Elsewhere"  , 
                "998: Code '218' in 1995-2006, not listed in documentation" ) 
var_levels <-  levels(Harmon$NatvtyF)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$NatvtyF)[valid_positions] <- valid_labels
table(Harmon$NatvtyF, useNA="ifany")


# Variable:NatvtyM Format: NATVTYF levels:174
Harmon$NatvtyM <- as.factor(Harmon$NatvtyM)
all_values <- c(57 ,60  , 66  , 69  , 73  , 78  , 96  , 100  , 102  , 103  , 104  , 105  , 106  , 108  , 109  , 110  , 116  , 117  , 118  , 119  , 120  , 126  , 127  , 128  , 129  , 130  , 132  , 134  , 136  , 137  , 138  , 139  , 140  , 141  , 142  , 147  , 148  , 149  , 150  , 151  , 152  , 154
 , 155  , 156  , 157  , 158  , 159  , 160  , 161  , 162  , 163  , 164  , 165  , 166  , 167  , 168  , 200  , 202  , 203  , 205  , 206  , 207  , 208  , 209  , 210  , 211  , 212  , 213  , 214  , 215  , 216  , 217  , 218  , 220  , 222  , 223  , 224  , 226  , 228  , 229  , 231  , 233  , 235  , 236  , 238
 , 239  , 240  , 242  , 243  , 245  , 246  , 247  , 248  , 249  , 252  , 253  , 300  , 301  , 303  , 304  , 310  , 311  , 312  , 313  , 314  , 315  , 316  , 318  , 321  , 323  , 324  , 327  , 328  , 329  , 330  , 332  , 333  , 338  , 339  , 340  , 341  , 343  , 360  , 361  , 362  , 363  , 364  , 365
 , 368  , 369  , 370  , 372  , 373  , 374  , 399  , 400  , 407  , 408  , 412  , 414  , 416  , 417  , 421  , 423  , 425  , 427  , 429  , 430  , 436  , 440  , 444  , 447  , 448  , 449  , 451  , 453  , 454  , 457  , 459  , 460  , 461  , 462  , 468  , 501  , 508  , 511  , 512  , 515  , 523  , 527  , 528
 , 529  , 555  , 998 ) 
all_levels <- c("57: United States" ,
                "60: American Samoa"  , 
                "66: Guam"  , 
                "69: Northern Marianas"  , 
                "73: Puerto Rico"  , 
                "78: U. S. Virgin Islands"  , 
                "96: Other U.S. Island Areas"  , 
                "100: Albania"  , 
                "102: Austria"  , 
                "103: Belgium"  , 
                "104: Bulgaria"  , 
                "105: Czechoslovakia"  , 
                "106: Denmark"  , 
                "108: Finland"  , 
                "109: France"  , 
                "110: Germany"  , 
                "116: Greece"  , 
                "117: Hungary"  , 
                "118: Iceland"  , 
                "119: Ireland"  , 
                "120: Italy"  , 
                "126: Netherlands"  , 
                "127: Norway"  , 
                "128: Poland"  , 
                "129: Portugal"  , 
                "130: Azores"  , 
                "132: Romania"  , 
                "134: Spain"  , 
                "136: Sweden"  , 
                "137: Switzerland"  , 
                "138: United Kingdom"  , 
                "139: England"  , 
                "140: Scotland"  , 
                "141: Wales"  , 
                "142: Northern Ireland"  , 
                "147: Yugoslavia"  , 
                "148: Czech Republic"  , 
                "149: Slovakia"  , 
                "150: Bosnia & Herzegovina"  , 
                "151: Croatia"  , 
                "152: Macedonia"  , 
                "154: Serbia"  , 
                "155: Estonia"  , 
                "156: Latvia"  , 
                "157: Lithuania"  , 
                "158: Armenia"  , 
                "159: Azerbaijan"  , 
                "160: Belarus"  , 
                "161: Georgia"  , 
                "162: Moldova"  , 
                "163: Russia"  , 
                "164: Ukraine"  , 
                "165: USSR"  , 
                "166: Europe, not specified"  , 
                "167: Kosovo"  , 
                "168: Montenegro"  , 
                "200: Afghanistan"  , 
                "202: Bangladesh"  , 
                "203: Bhutan"  , 
                "205: Myanmar (Burma)"  , 
                "206: Cambodia"  , 
                "207: China"  , 
                "208: Cyprus"  , 
                "209: Hong Kong"  , 
                "210: India"  , 
                "211: Indonesia"  , 
                "212: Iran"  , 
                "213: Iraq"  , 
                "214: Israel"  , 
                "215: Japan"  , 
                "216: Jordan"  , 
                "217: Korea/South Korea"  , 
                "218: Kazakhstan"  , 
                "220: South Korea"  , 
                "222: Kuwait"  , 
                "223: Laos"  , 
                "224: Lebanon"  , 
                "226: Malaysia"  , 
                "228: Mongolia"  , 
                "229: Nepal"  , 
                "231: Pakistan"  , 
                "233: Philippines"  , 
                "235: Saudi Arabia"  , 
                "236: Singapore"  , 
                "238: Sri Lanka"  , 
                "239: Syria"  , 
                "240: Taiwan"  , 
                "242: Thailand"  , 
                "243: Turkey"  , 
                "245: United Arab Emirates"  , 
                "246: Uzbekistan"  , 
                "247: Vietnam"  , 
                "248: Yemen"  , 
                "249: Asia, not specified"  , 
                "252: Middle East"  , 
                "253: Palestine"  , 
                "300: Bermuda"  , 
                "301: Canada"  , 
                "303: Mexico"  , 
                "304: North America"  , 
                "310: Belize"  , 
                "311: Costa Rica"  , 
                "312: El Salvador"  , 
                "313: Guatemala"  , 
                "314: Honduras"  , 
                "315: Nicaragua"  , 
                "316: Panama"  , 
                "318: Central America"  , 
                "321: Antigua and Barbuda"  , 
                "323: Bahamas"  , 
                "324: Barbados"  , 
                "327: Cuba"  , 
                "328: Dominica"  , 
                "329: Dominican Republic"  , 
                "330: Grenada"  , 
                "332: Haiti"  , 
                "333: Jamaica"  , 
                "338: St. Kitts--Nevis"  , 
                "339: St. Lucia"  , 
                "340: St. Vincent and the Grenadines"  , 
                "341: Trinidad and Tobago"  , 
                "343: West Indies, not specified"  , 
                "360: Argentina"  , 
                "361: Bolivia"  , 
                "362: Brazil"  , 
                "363: Chile"  , 
                "364: Columbia"  , 
                "365: Ecuador"  , 
                "368: Guyana"  , 
                "369: Paraguay"  , 
                "370: Peru"  , 
                "372: Uruguay"  , 
                "373: Venezuela"  , 
                "374: South America, not specified"  , 
                "399: Americas, not specified"  , 
                "400: Algeria"  , 
                "407: Cameroon"  , 
                "408: Cape Verde"  , 
                "412: Congo"  , 
                "414: Egypt"  , 
                "416: Ethiopia"  , 
                "417: Eritrea"  , 
                "421: Ghana"  , 
                "423: Guinea"  , 
                "425: Ivory Coast"  , 
                "427: Kenya"  , 
                "429: Liberia"  , 
                "430: Libya"  , 
                "436: Morocco"  , 
                "440: Nigeria"  , 
                "444: Senegal"  , 
                "447: Sierra Leone"  , 
                "448: Somalia"  , 
                "449: South Africa"  , 
                "451: Sudan"  , 
                "453: Tanzania"  , 
                "454: Togo"  , 
                "457: Uganda"  , 
                "459: Zaire"  , 
                "460: Zambia"  , 
                "461: Zimbabwe"  , 
                "462: Africa, not specified"  , 
                "468: North Africa"  , 
                "501: Australia"  , 
                "508: Fiji"  , 
                "511: Marshall Islands"  , 
                "512: Micronesia"  , 
                "515: New Zealand"  , 
                "523: Tonga"  , 
                "527: Samoa"  , 
                "528: Oceania, not specified"  , 
                "529: Pacific Islands"  , 
                "555: Elsewhere"  , 
                "998: Code '218' in 1995-2006, not listed in documentation" ) 
var_levels <-  levels(Harmon$NatvtyM)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$NatvtyM)[valid_positions] <- valid_labels
table(Harmon$NatvtyM, useNA="ifany")


# Variable:OCC1DT03 Format: OCCDT03F levels:24
Harmon$OCC1DT03 <- as.factor(Harmon$OCC1DT03)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Management occupations"  , 
                "2: Business and financial operations occupations"  , 
                "3: Computer and mathematical science occupations"  , 
                "4: Architecture and engineering occupations"  , 
                "5: Life, physical, and social science occupations"  , 
                "6: Community and social service occupations"  , 
                "7: Legal occupations"  , 
                "8: Education, training, and library occupations"  , 
                "9: Arts, design, entertainment, sports, and media occupations"  , 
                "10: Healthcare practitioner and technical occupations"  , 
                "11: Healthcare support occupations"  , 
                "12: Protective service occupations"  , 
                "13: Food preparation and serving related occupations"  , 
                "14: Building and grounds cleaning and maintenance occupations"  , 
                "15: Personal care and service occupations"  , 
                "16: Sales and related occupations"  , 
                "17: Office and administrative support occupations"  , 
                "18: Farming, fishing, and forestry occupations"  , 
                "19: Construction and extraction occupations"  , 
                "20: Installation, maintenance, and repair occupations"  , 
                "21: Production occupations"  , 
                "22: Transportation and material moving occupations"  , 
                "23: Armed Forces" ) 
var_levels <-  levels(Harmon$OCC1DT03)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$OCC1DT03)[valid_positions] <- valid_labels
table(Harmon$OCC1DT03, useNA="ifany")


# Variable:OCC1DT95 Format: OCCDT95F levels:47
Harmon$OCC1DT95 <- as.factor(Harmon$OCC1DT95)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23  , 24  , 25  , 26  , 27  , 28  , 29  , 30  , 31  , 32  , 33  , 34  , 35  , 36  , 37  , 38  , 39  , 40  , 41  , 42  , 43  , 44  , 45  , 46 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Officials & administrators,public admin."  , 
                "2: Other executive, admin. & managerial"  , 
                "3: Management related occupations"  , 
                "4: Engineers"  , 
                "5: Mathematical and computer scientists"  , 
                "6: Natural scientists"  , 
                "7: Health diagnosing occupations"  , 
                "8: Health assessment and treatment occupations"  , 
                "9: Teachers, college and university"  , 
                "10: Teachers, except college and university"  , 
                "11: Lawyers and judges"  , 
                "12: Other professional specialty occupations"  , 
                "13: Health technologists and technicians"  , 
                "14: Engineering and science technicians"  , 
                "15: Technicians, except health, engineering, and science"  , 
                "16: Supervisors and proprietors, sales occupations"  , 
                "17: Sales reps, finance and business services"  , 
                "18: Sales reps, commodities, except retail"  , 
                "19: Sales workers, retail & personal services"  , 
                "20: Sales related occupations"  , 
                "21: Supervisors, administrative support"  , 
                "22: Computer equiptment operators"  , 
                "23: Secretaries, stenographers, and typists"  , 
                "24: Financial records processing"  , 
                "25: Mail and message distribution"  , 
                "26: Other admin. support, including clerical"  , 
                "27: Private household service occupations"  , 
                "28: Protective service"  , 
                "29: Food service"  , 
                "30: Health service"  , 
                "31: Cleaning and building service"  , 
                "32: Personal service"  , 
                "33: Mechanics and repairers"  , 
                "34: Construction trades"  , 
                "35: Other precision production, craft, and repair"  , 
                "36: Machine operators, and tenders, except precision"  , 
                "37: Fabricators, assemblers, inspectors, samplers"  , 
                "38: Motor vehicle operators"  , 
                "39: Other transportation and material moving occupations"  , 
                "40: Construction laborers"  , 
                "41: Freight, stock, & materials handlers"  , 
                "42: Other handlers, equipt. cleaners, helpers, laborers"  , 
                "43: Farm operators and managers"  , 
                "44: Farm workers and related occupations"  , 
                "45: Forestry and fishing occupations"  , 
                "46: Armed forces" ) 
var_levels <-  levels(Harmon$OCC1DT95)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$OCC1DT95)[valid_positions] <- valid_labels
table(Harmon$OCC1DT95, useNA="ifany")


# Variable:OCC1MJ03 Format: OCCMJ03F levels:12
Harmon$OCC1MJ03 <- as.factor(Harmon$OCC1MJ03)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Management, business, and financial occupations"  , 
                "2: Professional and related occupations"  , 
                "3: Service occupations"  , 
                "4: Sales and related occupations"  , 
                "5: Office and administrative support occupations"  , 
                "6: Farming, fishing, and forestry occupations"  , 
                "7: Construction and extraction occupations"  , 
                "8: Installation, maintenance, and repair occupations"  , 
                "9: Production occupations"  , 
                "10: Transportation and material moving occupations"  , 
                "11: Armed Forces" ) 
var_levels <-  levels(Harmon$OCC1MJ03)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$OCC1MJ03)[valid_positions] <- valid_labels
table(Harmon$OCC1MJ03, useNA="ifany")


# Variable:OCC1MJ95 Format: OCCMJ95F levels:15
Harmon$OCC1MJ95 <- as.factor(Harmon$OCC1MJ95)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Executive, administrative, & managerial occupations"  , 
                "2: Professional specialty occupations"  , 
                "3: Technicians and related support occupations"  , 
                "4: Sales occupations"  , 
                "5: Administrative support occupations, including clerical"  , 
                "6: Private household occupations"  , 
                "7: Protective service occupations"  , 
                "8: Service occupations, except protective & hhld"  , 
                "9: Precision production, craft & repair occupations"  , 
                "10: Machine operators, assemblers & inspectors"  , 
                "11: Transportation and material moving occupations"  , 
                "12: Handlers, equip cleaners, helpers, laborers"  , 
                "13: Farming, forestry and fishing occupations"  , 
                "14: Armed forces" ) 
var_levels <-  levels(Harmon$OCC1MJ95)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$OCC1MJ95)[valid_positions] <- valid_labels
table(Harmon$OCC1MJ95, useNA="ifany")


# Variable:OCC2DT03 Format: OCCDT03F levels:24
Harmon$OCC2DT03 <- as.factor(Harmon$OCC2DT03)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Management occupations"  , 
                "2: Business and financial operations occupations"  , 
                "3: Computer and mathematical science occupations"  , 
                "4: Architecture and engineering occupations"  , 
                "5: Life, physical, and social science occupations"  , 
                "6: Community and social service occupations"  , 
                "7: Legal occupations"  , 
                "8: Education, training, and library occupations"  , 
                "9: Arts, design, entertainment, sports, and media occupations"  , 
                "10: Healthcare practitioner and technical occupations"  , 
                "11: Healthcare support occupations"  , 
                "12: Protective service occupations"  , 
                "13: Food preparation and serving related occupations"  , 
                "14: Building and grounds cleaning and maintenance occupations"  , 
                "15: Personal care and service occupations"  , 
                "16: Sales and related occupations"  , 
                "17: Office and administrative support occupations"  , 
                "18: Farming, fishing, and forestry occupations"  , 
                "19: Construction and extraction occupations"  , 
                "20: Installation, maintenance, and repair occupations"  , 
                "21: Production occupations"  , 
                "22: Transportation and material moving occupations"  , 
                "23: Armed Forces" ) 
var_levels <-  levels(Harmon$OCC2DT03)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$OCC2DT03)[valid_positions] <- valid_labels
table(Harmon$OCC2DT03, useNA="ifany")


# Variable:OCC2DT95 Format: OCCDT95F levels:47
Harmon$OCC2DT95 <- as.factor(Harmon$OCC2DT95)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23  , 24  , 25  , 26  , 27  , 28  , 29  , 30  , 31  , 32  , 33  , 34  , 35  , 36  , 37  , 38  , 39  , 40  , 41  , 42  , 43  , 44  , 45  , 46 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Officials & administrators,public admin."  , 
                "2: Other executive, admin. & managerial"  , 
                "3: Management related occupations"  , 
                "4: Engineers"  , 
                "5: Mathematical and computer scientists"  , 
                "6: Natural scientists"  , 
                "7: Health diagnosing occupations"  , 
                "8: Health assessment and treatment occupations"  , 
                "9: Teachers, college and university"  , 
                "10: Teachers, except college and university"  , 
                "11: Lawyers and judges"  , 
                "12: Other professional specialty occupations"  , 
                "13: Health technologists and technicians"  , 
                "14: Engineering and science technicians"  , 
                "15: Technicians, except health, engineering, and science"  , 
                "16: Supervisors and proprietors, sales occupations"  , 
                "17: Sales reps, finance and business services"  , 
                "18: Sales reps, commodities, except retail"  , 
                "19: Sales workers, retail & personal services"  , 
                "20: Sales related occupations"  , 
                "21: Supervisors, administrative support"  , 
                "22: Computer equiptment operators"  , 
                "23: Secretaries, stenographers, and typists"  , 
                "24: Financial records processing"  , 
                "25: Mail and message distribution"  , 
                "26: Other admin. support, including clerical"  , 
                "27: Private household service occupations"  , 
                "28: Protective service"  , 
                "29: Food service"  , 
                "30: Health service"  , 
                "31: Cleaning and building service"  , 
                "32: Personal service"  , 
                "33: Mechanics and repairers"  , 
                "34: Construction trades"  , 
                "35: Other precision production, craft, and repair"  , 
                "36: Machine operators, and tenders, except precision"  , 
                "37: Fabricators, assemblers, inspectors, samplers"  , 
                "38: Motor vehicle operators"  , 
                "39: Other transportation and material moving occupations"  , 
                "40: Construction laborers"  , 
                "41: Freight, stock, & materials handlers"  , 
                "42: Other handlers, equipt. cleaners, helpers, laborers"  , 
                "43: Farm operators and managers"  , 
                "44: Farm workers and related occupations"  , 
                "45: Forestry and fishing occupations"  , 
                "46: Armed forces" ) 
var_levels <-  levels(Harmon$OCC2DT95)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$OCC2DT95)[valid_positions] <- valid_labels
table(Harmon$OCC2DT95, useNA="ifany")


# Variable:OCC2MJ03 Format: OCCMJ03F levels:12
Harmon$OCC2MJ03 <- as.factor(Harmon$OCC2MJ03)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Management, business, and financial occupations"  , 
                "2: Professional and related occupations"  , 
                "3: Service occupations"  , 
                "4: Sales and related occupations"  , 
                "5: Office and administrative support occupations"  , 
                "6: Farming, fishing, and forestry occupations"  , 
                "7: Construction and extraction occupations"  , 
                "8: Installation, maintenance, and repair occupations"  , 
                "9: Production occupations"  , 
                "10: Transportation and material moving occupations"  , 
                "11: Armed Forces" ) 
var_levels <-  levels(Harmon$OCC2MJ03)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$OCC2MJ03)[valid_positions] <- valid_labels
table(Harmon$OCC2MJ03, useNA="ifany")


# Variable:OCC2MJ95 Format: OCCMJ95F levels:15
Harmon$OCC2MJ95 <- as.factor(Harmon$OCC2MJ95)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Executive, administrative, & managerial occupations"  , 
                "2: Professional specialty occupations"  , 
                "3: Technicians and related support occupations"  , 
                "4: Sales occupations"  , 
                "5: Administrative support occupations, including clerical"  , 
                "6: Private household occupations"  , 
                "7: Protective service occupations"  , 
                "8: Service occupations, except protective & hhld"  , 
                "9: Precision production, craft & repair occupations"  , 
                "10: Machine operators, assemblers & inspectors"  , 
                "11: Transportation and material moving occupations"  , 
                "12: Handlers, equip cleaners, helpers, laborers"  , 
                "13: Farming, forestry and fishing occupations"  , 
                "14: Armed forces" ) 
var_levels <-  levels(Harmon$OCC2MJ95)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$OCC2MJ95)[valid_positions] <- valid_labels
table(Harmon$OCC2MJ95, useNA="ifany")


# Variable:OTWk Format: OTWKF levels:6
Harmon$OTWk <- as.factor(Harmon$OTWk)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$OTWk)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$OTWk)[valid_positions] <- valid_labels
table(Harmon$OTWk, useNA="ifany")


# Variable:OwnBsFrm Format: OWNBSFRF levels:6
Harmon$OwnBsFrm <- as.factor(Harmon$OwnBsFrm)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$OwnBsFrm)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$OwnBsFrm)[valid_positions] <- valid_labels
table(Harmon$OwnBsFrm, useNA="ifany")


# Variable:PIPECURR Format: OTPCURRF levels:8
Harmon$PIPECURR <- as.factor(Harmon$PIPECURR)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: Indeterminate" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Never"  , 
                "2: Current"  , 
                "3: Former" ) 
var_levels <-  levels(Harmon$PIPECURR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PIPECURR)[valid_positions] <- valid_labels
table(Harmon$PIPECURR, useNA="ifany")


# Variable:PIPEDAY Format: OTPDAYF levels:5
Harmon$PIPEDAY <- as.factor(Harmon$PIPEDAY)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No Response" ,
                "-5: Did not use in the past 30 days"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$PIPEDAY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PIPEDAY)[valid_positions] <- valid_labels
table(Harmon$PIPEDAY, useNA="ifany")


# Variable:PIPEEVER Format: OTPEVERF levels:7
Harmon$PIPEEVER <- as.factor(Harmon$PIPEEVER)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PIPEEVER)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PIPEEVER)[valid_positions] <- valid_labels
table(Harmon$PIPEEVER, useNA="ifany")


# Variable:PIPEFLVR Format: OTPFLVF levels:6
Harmon$PIPEFLVR <- as.factor(Harmon$PIPEFLVR)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PIPEFLVR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PIPEFLVR)[valid_positions] <- valid_labels
table(Harmon$PIPEFLVR, useNA="ifany")


# Variable:PIPELOTQ Format: OTPLOTQF levels:5
Harmon$PIPELOTQ <- as.factor(Harmon$PIPELOTQ)
all_values <- c(-99 ,-9  , -3  , -2  , -1 ) 
all_levels <- c("-99: Only used once or twice" ,
                "-9: No Response"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$PIPELOTQ)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PIPELOTQ)[valid_positions] <- valid_labels
table(Harmon$PIPELOTQ, useNA="ifany")


# Variable:PIPENOW Format: OTPNOWF levels:7
Harmon$PIPENOW <- as.factor(Harmon$PIPENOW)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PIPENOW)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PIPENOW)[valid_positions] <- valid_labels
table(Harmon$PIPENOW, useNA="ifany")


# Variable:PIPENOW2 Format: OTPNOW2F levels:8
Harmon$PIPENOW2 <- as.factor(Harmon$PIPENOW2)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Every day"  , 
                "2: Some days"  , 
                "3: Former" ) 
var_levels <-  levels(Harmon$PIPENOW2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PIPENOW2)[valid_positions] <- valid_labels
table(Harmon$PIPENOW2, useNA="ifany")


# Variable:PIPESTAT Format: OTPSTATF levels:9
Harmon$PIPESTAT <- as.factor(Harmon$PIPESTAT)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3  , 4 ) 
all_levels <- c("-9: Indeterminate" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Never"  , 
                "2: Every day"  , 
                "3: Some days"  , 
                "4: Former" ) 
var_levels <-  levels(Harmon$PIPESTAT)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PIPESTAT)[valid_positions] <- valid_labels
table(Harmon$PIPESTAT, useNA="ifany")


# Variable:PIPEYRS Format: OTPYRSF levels:4
Harmon$PIPEYRS <- as.factor(Harmon$PIPEYRS)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No Response" ,
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$PIPEYRS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PIPEYRS)[valid_positions] <- valid_labels
table(Harmon$PIPEYRS, useNA="ifany")


# Variable:PYLTOTP Format: PYLTOTPF levels:4
Harmon$PYLTOTP <- as.factor(Harmon$PYLTOTP)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$PYLTOTP)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYLTOTP)[valid_positions] <- valid_labels
table(Harmon$PYLTOTP, useNA="ifany")


# Variable:PYMLTD Format: PYMLTDF levels:4
Harmon$PYMLTD <- as.factor(Harmon$PYMLTD)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$PYMLTD)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYMLTD)[valid_positions] <- valid_labels
table(Harmon$PYMLTD, useNA="ifany")


# Variable:PYMLTDU Format: PYMLTDF levels:4
Harmon$PYMLTDU <- as.factor(Harmon$PYMLTDU)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$PYMLTDU)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYMLTDU)[valid_positions] <- valid_labels
table(Harmon$PYMLTDU, useNA="ifany")


# Variable:PYMLTHS Format: PYMLTHSF levels:4
Harmon$PYMLTHS <- as.factor(Harmon$PYMLTHS)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$PYMLTHS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYMLTHS)[valid_positions] <- valid_labels
table(Harmon$PYMLTHS, useNA="ifany")


# Variable:PYMLTHSU Format: PYMLTHSF levels:4
Harmon$PYMLTHSU <- as.factor(Harmon$PYMLTHSU)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$PYMLTHSU)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYMLTHSU)[valid_positions] <- valid_labels
table(Harmon$PYMLTHSU, useNA="ifany")


# Variable:PYMLTLS Format: PYMLTLSF levels:4
Harmon$PYMLTLS <- as.factor(Harmon$PYMLTLS)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$PYMLTLS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYMLTLS)[valid_positions] <- valid_labels
table(Harmon$PYMLTLS, useNA="ifany")


# Variable:PYMLTLSU Format: PYMLTLSF levels:4
Harmon$PYMLTLSU <- as.factor(Harmon$PYMLTLSU)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$PYMLTLSU)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYMLTLSU)[valid_positions] <- valid_labels
table(Harmon$PYMLTLSU, useNA="ifany")


# Variable:PYQHLP7A Format: PYQHLP7F levels:7
Harmon$PYQHLP7A <- as.factor(Harmon$PYQHLP7A)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Acupuncture"  , 
                "2: Hypnosis"  , 
                "3: Both" ) 
var_levels <-  levels(Harmon$PYQHLP7A)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQHLP7A)[valid_positions] <- valid_labels
table(Harmon$PYQHLP7A, useNA="ifany")


# Variable:PYQPTN4A Format: PYQPTN4F levels:6
Harmon$PYQPTN4A <- as.factor(Harmon$PYQPTN4A)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQPTN4A)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQPTN4A)[valid_positions] <- valid_labels
table(Harmon$PYQPTN4A, useNA="ifany")


# Variable:PYQTHLP1 Format: PYQTHLPF levels:6
Harmon$PYQTHLP1 <- as.factor(Harmon$PYQTHLP1)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQTHLP1)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQTHLP1)[valid_positions] <- valid_labels
table(Harmon$PYQTHLP1, useNA="ifany")


# Variable:PYQTHLP2 Format: PYQTHLPF levels:6
Harmon$PYQTHLP2 <- as.factor(Harmon$PYQTHLP2)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQTHLP2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQTHLP2)[valid_positions] <- valid_labels
table(Harmon$PYQTHLP2, useNA="ifany")


# Variable:PYQTHLP3 Format: PYQTHLPF levels:6
Harmon$PYQTHLP3 <- as.factor(Harmon$PYQTHLP3)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQTHLP3)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQTHLP3)[valid_positions] <- valid_labels
table(Harmon$PYQTHLP3, useNA="ifany")


# Variable:PYQTHLP4 Format: PYQTHLPF levels:6
Harmon$PYQTHLP4 <- as.factor(Harmon$PYQTHLP4)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQTHLP4)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQTHLP4)[valid_positions] <- valid_labels
table(Harmon$PYQTHLP4, useNA="ifany")


# Variable:PYQTHLP5 Format: PYQTHLPF levels:6
Harmon$PYQTHLP5 <- as.factor(Harmon$PYQTHLP5)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQTHLP5)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQTHLP5)[valid_positions] <- valid_labels
table(Harmon$PYQTHLP5, useNA="ifany")


# Variable:PYQTHLP6 Format: PYQTHLPF levels:6
Harmon$PYQTHLP6 <- as.factor(Harmon$PYQTHLP6)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQTHLP6)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQTHLP6)[valid_positions] <- valid_labels
table(Harmon$PYQTHLP6, useNA="ifany")


# Variable:PYQTHLP7 Format: PYQTHLPF levels:6
Harmon$PYQTHLP7 <- as.factor(Harmon$PYQTHLP7)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQTHLP7)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQTHLP7)[valid_positions] <- valid_labels
table(Harmon$PYQTHLP7, useNA="ifany")


# Variable:PYQTNRT1 Format: PYQTNRTF levels:6
Harmon$PYQTNRT1 <- as.factor(Harmon$PYQTNRT1)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQTNRT1)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQTNRT1)[valid_positions] <- valid_labels
table(Harmon$PYQTNRT1, useNA="ifany")


# Variable:PYQTNRT2 Format: PYQTNRTF levels:6
Harmon$PYQTNRT2 <- as.factor(Harmon$PYQTNRT2)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQTNRT2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQTNRT2)[valid_positions] <- valid_labels
table(Harmon$PYQTNRT2, useNA="ifany")


# Variable:PYQTNRT3 Format: PYQTNRTF levels:6
Harmon$PYQTNRT3 <- as.factor(Harmon$PYQTNRT3)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQTNRT3)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQTNRT3)[valid_positions] <- valid_labels
table(Harmon$PYQTNRT3, useNA="ifany")


# Variable:PYQTNRT4 Format: PYQTNRTF levels:6
Harmon$PYQTNRT4 <- as.factor(Harmon$PYQTNRT4)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQTNRT4)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQTNRT4)[valid_positions] <- valid_labels
table(Harmon$PYQTNRT4, useNA="ifany")


# Variable:PYQTPTN1 Format: PYQTPTNF levels:6
Harmon$PYQTPTN1 <- as.factor(Harmon$PYQTPTN1)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQTPTN1)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQTPTN1)[valid_positions] <- valid_labels
table(Harmon$PYQTPTN1, useNA="ifany")


# Variable:PYQTPTN2 Format: PYQTPTNF levels:6
Harmon$PYQTPTN2 <- as.factor(Harmon$PYQTPTN2)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQTPTN2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQTPTN2)[valid_positions] <- valid_labels
table(Harmon$PYQTPTN2, useNA="ifany")


# Variable:PYQTPTN3 Format: PYQTPTNF levels:6
Harmon$PYQTPTN3 <- as.factor(Harmon$PYQTPTN3)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQTPTN3)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQTPTN3)[valid_positions] <- valid_labels
table(Harmon$PYQTPTN3, useNA="ifany")


# Variable:PYQTPTN4 Format: PYQTPTNF levels:6
Harmon$PYQTPTN4 <- as.factor(Harmon$PYQTPTN4)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQTPTN4)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQTPTN4)[valid_positions] <- valid_labels
table(Harmon$PYQTPTN4, useNA="ifany")


# Variable:PYQTPTN5 Format: PYQTPTNF levels:6
Harmon$PYQTPTN5 <- as.factor(Harmon$PYQTPTN5)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQTPTN5)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQTPTN5)[valid_positions] <- valid_labels
table(Harmon$PYQTPTN5, useNA="ifany")


# Variable:PYQUITSD Format: PYQUITSF levels:6
Harmon$PYQUITSD <- as.factor(Harmon$PYQUITSD)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYQUITSD)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYQUITSD)[valid_positions] <- valid_labels
table(Harmon$PYQUITSD, useNA="ifany")


# Variable:PYSTP1DD Format: PYSTP1DF levels:6
Harmon$PYSTP1DD <- as.factor(Harmon$PYSTP1DD)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYSTP1DD)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYSTP1DD)[valid_positions] <- valid_labels
table(Harmon$PYSTP1DD, useNA="ifany")


# Variable:PYSTP1DS Format: PYSTP1DF levels:6
Harmon$PYSTP1DS <- as.factor(Harmon$PYSTP1DS)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYSTP1DS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYSTP1DS)[valid_positions] <- valid_labels
table(Harmon$PYSTP1DS, useNA="ifany")


# Variable:PYSTPOTP Format: PYSTPOTF levels:6
Harmon$PYSTPOTP <- as.factor(Harmon$PYSTPOTP)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYSTPOTP)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYSTPOTP)[valid_positions] <- valid_labels
table(Harmon$PYSTPOTP, useNA="ifany")


# Variable:PYTRYQD Format: PYTRYQDF levels:6
Harmon$PYTRYQD <- as.factor(Harmon$PYTRYQD)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYTRYQD)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYTRYQD)[valid_positions] <- valid_labels
table(Harmon$PYTRYQD, useNA="ifany")


# Variable:PYTRYQS Format: PYTRYQSF levels:6
Harmon$PYTRYQS <- as.factor(Harmon$PYTRYQS)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$PYTRYQS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$PYTRYQS)[valid_positions] <- valid_labels
table(Harmon$PYTRYQS, useNA="ifany")


# Variable:QUITSUCS Format: QUITSUCF levels:8
Harmon$QUITSUCS <- as.factor(Harmon$QUITSUCS)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3  , 4 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Not at all"  , 
                "2: A little likely"  , 
                "3: Somewhat likely"  , 
                "4: Very likely" ) 
var_levels <-  levels(Harmon$QUITSUCS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$QUITSUCS)[valid_positions] <- valid_labels
table(Harmon$QUITSUCS, useNA="ifany")


# Variable:Race03 Format: RACE03F levels:21
Harmon$Race03 <- as.factor(Harmon$Race03)
all_values <- c(1 ,2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10  , 11  , 12  , 13  , 14  , 15  , 16  , 17  , 18  , 19  , 20  , 21 ) 
all_levels <- c("1: White Only" ,
                "2: Black Only"  , 
                "3: American Indian, Alaskan Native Only"  , 
                "4: Asian Only"  , 
                "5: Hawaiian/Pacific Islander Only"  , 
                "6: White-Black"  , 
                "7: White-AI"  , 
                "8: White-Asian"  , 
                "9: White-Hawaiian"  , 
                "10: Black-AI"  , 
                "11: Black-Asian"  , 
                "12: Black-HP"  , 
                "13: AI-Asian"  , 
                "14: Asian-HP"  , 
                "15: W-B-AI"  , 
                "16: W-B-A"  , 
                "17: W-AI-A"  , 
                "18: W-A-HP"  , 
                "19: W-B-AI-A"  , 
                "20: 2 or 3 Races"  , 
                "21: 4 or 5 Races" ) 
var_levels <-  levels(Harmon$Race03)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$Race03)[valid_positions] <- valid_labels
table(Harmon$Race03, useNA="ifany")


# Variable:Race92 Format: RACE92F levels:5
Harmon$Race92 <- as.factor(Harmon$Race92)
all_values <- c(1 ,2  , 3  , 4  , 5 ) 
all_levels <- c("1: White" ,
                "2: Black"  , 
                "3: American Indian, Aleut, Eskimo"  , 
                "4: Asian or Pacific Islander"  , 
                "5: Other" ) 
var_levels <-  levels(Harmon$Race92)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$Race92)[valid_positions] <- valid_labels
table(Harmon$Race92, useNA="ifany")


# Variable:Region Format: REGIONF levels:4
Harmon$Region <- as.factor(Harmon$Region)
all_values <- c(1 ,2  , 3  , 4 ) 
all_levels <- c("1: Northeast" ,
                "2: Midwest"  , 
                "3: South"  , 
                "4: West" ) 
var_levels <-  levels(Harmon$Region)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$Region)[valid_positions] <- valid_labels
table(Harmon$Region, useNA="ifany")


# Variable:SDEVRCIG Format: SDEVRCIF levels:4
Harmon$SDEVRCIG <- as.factor(Harmon$SDEVRCIG)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$SDEVRCIG)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SDEVRCIG)[valid_positions] <- valid_labels
table(Harmon$SDEVRCIG, useNA="ifany")


# Variable:SDEVRDLY Format: SDEVRDLF levels:6
Harmon$SDEVRDLY <- as.factor(Harmon$SDEVRDLY)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$SDEVRDLY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SDEVRDLY)[valid_positions] <- valid_labels
table(Harmon$SDEVRDLY, useNA="ifany")


# Variable:SDYRSDLY Format: SDYRSDLF levels:4
Harmon$SDYRSDLY <- as.factor(Harmon$SDYRSDLY)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$SDYRSDLY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SDYRSDLY)[valid_positions] <- valid_labels
table(Harmon$SDYRSDLY, useNA="ifany")


# Variable:SDYRSMKC Format: SDYRSMCF levels:5
Harmon$SDYRSMKC <- as.factor(Harmon$SDYRSMKC)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-5: None or less than 1 year"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$SDYRSMKC)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SDYRSMKC)[valid_positions] <- valid_labels
table(Harmon$SDYRSMKC, useNA="ifany")


# Variable:SDYRSMKG Format: SDYRSMGF levels:9
Harmon$SDYRSMKG <- as.factor(Harmon$SDYRSMKG)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3  , 4  , 5 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: All or nearly all the years you have smoked"  , 
                "2: Most of the years you have smoked"  , 
                "3: Half of the years you have smoked"  , 
                "4: Less than half of the years you have smoked"  , 
                "5: Less than one year (if volunteered)" ) 
var_levels <-  levels(Harmon$SDYRSMKG)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SDYRSMKG)[valid_positions] <- valid_labels
table(Harmon$SDYRSMKG, useNA="ifany")


# Variable:SMKLCURR Format: OTPCURRF levels:8
Harmon$SMKLCURR <- as.factor(Harmon$SMKLCURR)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: Indeterminate" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Never"  , 
                "2: Current"  , 
                "3: Former" ) 
var_levels <-  levels(Harmon$SMKLCURR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SMKLCURR)[valid_positions] <- valid_labels
table(Harmon$SMKLCURR, useNA="ifany")


# Variable:SMKLDAY Format: OTPDAYF levels:5
Harmon$SMKLDAY <- as.factor(Harmon$SMKLDAY)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No Response" ,
                "-5: Did not use in the past 30 days"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$SMKLDAY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SMKLDAY)[valid_positions] <- valid_labels
table(Harmon$SMKLDAY, useNA="ifany")


# Variable:SMKLEVER Format: OTPEVERF levels:7
Harmon$SMKLEVER <- as.factor(Harmon$SMKLEVER)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$SMKLEVER)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SMKLEVER)[valid_positions] <- valid_labels
table(Harmon$SMKLEVER, useNA="ifany")


# Variable:SMKLFLVR Format: OTPFLVF levels:6
Harmon$SMKLFLVR <- as.factor(Harmon$SMKLFLVR)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$SMKLFLVR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SMKLFLVR)[valid_positions] <- valid_labels
table(Harmon$SMKLFLVR, useNA="ifany")


# Variable:SMKLLOTQ Format: OTPLOTQF levels:5
Harmon$SMKLLOTQ <- as.factor(Harmon$SMKLLOTQ)
all_values <- c(-99 ,-9  , -3  , -2  , -1 ) 
all_levels <- c("-99: Only used once or twice" ,
                "-9: No Response"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$SMKLLOTQ)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SMKLLOTQ)[valid_positions] <- valid_labels
table(Harmon$SMKLLOTQ, useNA="ifany")


# Variable:SMKLNOW Format: OTPNOWF levels:7
Harmon$SMKLNOW <- as.factor(Harmon$SMKLNOW)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$SMKLNOW)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SMKLNOW)[valid_positions] <- valid_labels
table(Harmon$SMKLNOW, useNA="ifany")


# Variable:SMKLNOW2 Format: OTPNOW2F levels:8
Harmon$SMKLNOW2 <- as.factor(Harmon$SMKLNOW2)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Every day"  , 
                "2: Some days"  , 
                "3: Former" ) 
var_levels <-  levels(Harmon$SMKLNOW2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SMKLNOW2)[valid_positions] <- valid_labels
table(Harmon$SMKLNOW2, useNA="ifany")


# Variable:SMKLSTAT Format: OTPSTATF levels:9
Harmon$SMKLSTAT <- as.factor(Harmon$SMKLSTAT)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3  , 4 ) 
all_levels <- c("-9: Indeterminate" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Never"  , 
                "2: Every day"  , 
                "3: Some days"  , 
                "4: Former" ) 
var_levels <-  levels(Harmon$SMKLSTAT)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SMKLSTAT)[valid_positions] <- valid_labels
table(Harmon$SMKLSTAT, useNA="ifany")


# Variable:SMKLYRS Format: OTPYRSF levels:4
Harmon$SMKLYRS <- as.factor(Harmon$SMKLYRS)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No Response" ,
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$SMKLYRS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SMKLYRS)[valid_positions] <- valid_labels
table(Harmon$SMKLYRS, useNA="ifany")


# Variable:SNFFCURR Format: OTPCURRF levels:8
Harmon$SNFFCURR <- as.factor(Harmon$SNFFCURR)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: Indeterminate" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Never"  , 
                "2: Current"  , 
                "3: Former" ) 
var_levels <-  levels(Harmon$SNFFCURR)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SNFFCURR)[valid_positions] <- valid_labels
table(Harmon$SNFFCURR, useNA="ifany")


# Variable:SNFFDAY Format: OTPDAYF levels:5
Harmon$SNFFDAY <- as.factor(Harmon$SNFFDAY)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No Response" ,
                "-5: Did not use in the past 30 days"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$SNFFDAY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SNFFDAY)[valid_positions] <- valid_labels
table(Harmon$SNFFDAY, useNA="ifany")


# Variable:SNFFEVER Format: OTPEVERF levels:7
Harmon$SNFFEVER <- as.factor(Harmon$SNFFEVER)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$SNFFEVER)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SNFFEVER)[valid_positions] <- valid_labels
table(Harmon$SNFFEVER, useNA="ifany")


# Variable:SNFFNOW Format: OTPNOWF levels:7
Harmon$SNFFNOW <- as.factor(Harmon$SNFFNOW)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$SNFFNOW)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SNFFNOW)[valid_positions] <- valid_labels
table(Harmon$SNFFNOW, useNA="ifany")


# Variable:SNFFNOW2 Format: OTPNOW2F levels:8
Harmon$SNFFNOW2 <- as.factor(Harmon$SNFFNOW2)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No Response" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Every day"  , 
                "2: Some days"  , 
                "3: Former" ) 
var_levels <-  levels(Harmon$SNFFNOW2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SNFFNOW2)[valid_positions] <- valid_labels
table(Harmon$SNFFNOW2, useNA="ifany")


# Variable:SNFFSTAT Format: OTPSTATF levels:9
Harmon$SNFFSTAT <- as.factor(Harmon$SNFFSTAT)
all_values <- c(-9 ,-8  , -3  , -2  , -1  , 1  , 2  , 3  , 4 ) 
all_levels <- c("-9: Indeterminate" ,
                "-8: Not available"  , 
                "-3: Refused"  , 
                "-2 :Don't know"  , 
                "-1: Not in universe"  , 
                "1: Never"  , 
                "2: Every day"  , 
                "3: Some days"  , 
                "4: Former" ) 
var_levels <-  levels(Harmon$SNFFSTAT)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SNFFSTAT)[valid_positions] <- valid_labels
table(Harmon$SNFFSTAT, useNA="ifany")


# Variable:SNGLCIG Format: SNGLCIGF levels:7
Harmon$SNGLCIG <- as.factor(Harmon$SNGLCIG)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes/Yes, bought"  , 
                "2: No/No, did not buy"  , 
                "3: Traded (2010-2011 only)" ) 
var_levels <-  levels(Harmon$SNGLCIG)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SNGLCIG)[valid_positions] <- valid_labels
table(Harmon$SNGLCIG, useNA="ifany")


# Variable:SNGLSTCT Format: SNGLSTCF levels:65
Harmon$SNGLSTCT <- as.factor(Harmon$SNGLSTCT)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 4  , 5  , 6  , 8  , 9  , 10  , 11  , 12  , 13  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23  , 24  , 25  , 26  , 27  , 28  , 29  , 30  , 31  , 32  , 33  , 34  , 35  , 36  , 37  , 38  , 39  , 40  , 41  , 42  , 44  , 45  , 46  , 47  , 48  , 49
 , 50  , 51  , 53  , 54  , 55  , 56  , 57  , 73  , 99  , 110  , 210  , 303  , 365  , 462  , 528  , 555 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Alabama"  , 
                "2: Alaska"  , 
                "4: Arizona"  , 
                "5: Arkansas"  , 
                "6: California"  , 
                "8: Colorado"  , 
                "9: Connecticut"  , 
                "10: Delaware"  , 
                "11: District of Columbia"  , 
                "12: Florida"  , 
                "13: Georgia"  , 
                "15: Hawaii"  , 
                "16: Idaho"  , 
                "17: Illinois"  , 
                "18: Indiana"  , 
                "19: Iowa"  , 
                "20: Kansas"  , 
                "21: Kentucky"  , 
                "22: Louisiana"  , 
                "23: Maine"  , 
                "24: Maryland"  , 
                "25: Massachusetts"  , 
                "26: Michigan"  , 
                "27: Minnesota"  , 
                "28: Mississippi"  , 
                "29: Missouri"  , 
                "30: Montana"  , 
                "31: Nebraska"  , 
                "32: Nevada"  , 
                "33: New Hampshire"  , 
                "34: New Jersey"  , 
                "35: New Mexico"  , 
                "36: New York"  , 
                "37: North Carolina"  , 
                "38: North Dakota"  , 
                "39: Ohio"  , 
                "40: Oklahoma"  , 
                "41: Oregon"  , 
                "42: Pennsylvania"  , 
                "44: Rhode Island"  , 
                "45: South Carolina"  , 
                "46: South Dakota"  , 
                "47: Tennessee"  , 
                "48: Texas"  , 
                "49: Utah"  , 
                "50: Vermont"  , 
                "51: Virginia"  , 
                "53: Washington"  , 
                "54: West Virginia"  , 
                "55: Wisconsin"  , 
                "56: Wyoming"  , 
                "57: United States (state unknown)"  , 
                "73: Puerto Rico"  , 
                "99: NA"  , 
                "110: Germany"  , 
                "210: India"  , 
                "303: Mexico"  , 
                "365: Ecuador"  , 
                "462: Africa, not specified"  , 
                "528: Oceania, not specified"  , 
                "555: Elsewhere" ) 
var_levels <-  levels(Harmon$SNGLSTCT)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SNGLSTCT)[valid_positions] <- valid_labels
table(Harmon$SNGLSTCT, useNA="ifany")


# Variable:SNGLWHER Format: SNGLWHEF levels:8
Harmon$SNGLWHER <- as.factor(Harmon$SNGLWHER)
all_values <- c(-9 ,-5  , -3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-5: Bought some other way"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: In respondent's state of residence"  , 
                "2: In some other state (including DC)"  , 
                "3: In another country" ) 
var_levels <-  levels(Harmon$SNGLWHER)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SNGLWHER)[valid_positions] <- valid_labels
table(Harmon$SNGLWHER, useNA="ifany")


# Variable:Sex Format: SEXF levels:2
Harmon$Sex <- as.factor(Harmon$Sex)
all_values <- c(1 ,2 ) 
all_levels <- c("1: Male" ,
                "2: Female" ) 
var_levels <-  levels(Harmon$Sex)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$Sex)[valid_positions] <- valid_labels
table(Harmon$Sex, useNA="ifany")


# Variable:SpanHome Format: SPANHOMF levels:2
Harmon$SpanHome <- as.factor(Harmon$SpanHome)
all_values <- c(0 ,1 ) 
all_levels <- c("0: Spanish not only language spoken" ,
                "1: Spanish only language spoken" ) 
var_levels <-  levels(Harmon$SpanHome)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SpanHome)[valid_positions] <- valid_labels
table(Harmon$SpanHome, useNA="ifany")


# Variable:StCounty Format: STCOUNTF levels:460
Harmon$StCounty <- as.factor(Harmon$StCounty)
all_values <- c(1000 ,1003  , 1015  , 1073  , 1081  , 1089  , 1097  , 1117  , 1125  , 2000  , 2020  , 4000  , 4003  , 4013  , 4015  , 4019  , 4021  , 4025  , 4027  , 5000  , 5119  , 6000  , 6001  , 6007  , 6013  , 6017  , 6019  , 6025  , 6029  , 6031  , 6037  , 6039  , 6041  , 6047  , 6053  , 6055
 , 6059  , 6061  , 6065  , 6067  , 6071  , 6073  , 6075  , 6077  , 6079  , 6081  , 6083  , 6085  , 6087  , 6089  , 6095  , 6097  , 6099  , 6107  , 6111  , 6113  , 8000  , 8005  , 8013  , 8031  , 8035  , 8041  , 8059  , 8069  , 8101  , 8123  , 9000  , 9001  , 9005  , 9009  , 9011  , 9015  , 10000  , 
10001  , 10003  , 10005  , 11001  , 12000  , 12001  , 12005  , 12009  , 12011  , 12015  , 12019  , 12021  , 12025  , 12033  , 12053  , 12057  , 12061  , 12069  , 12071  , 12081  , 12083  , 12085  , 12086  , 12091  , 12095  , 12097  , 12099  , 12101  , 12103  , 12105  , 12109  , 12111  , 12113  , 
12115  , 12117  , 12127  , 13000  , 13015  , 13045  , 13057  , 13063  , 13067  , 13077  , 13089  , 13097  , 13113  , 13117  , 13121  , 13135  , 13139  , 13151  , 13153  , 13223  , 15000  , 15001  , 15003  , 16000  , 16055  , 17000  , 17091  , 17097  , 17099  , 17111  , 17113  , 17115  , 17119  , 
17163  , 17179  , 18000  , 18019  , 18039  , 18057  , 18063  , 18081  , 18089  , 18091  , 18095  , 18105  , 18127  , 18141  , 19000  , 19013  , 19103  , 19113  , 19153  , 19163  , 20000  , 20045  , 20091  , 20173  , 20177  , 21000  , 21015  , 21067  , 21111  , 21117  , 22000  , 22005  , 22019  , 
22033  , 22051  , 22063  , 22071  , 22073  , 22103  , 23000  , 23001  , 23005  , 23011  , 23019  , 24000  , 24003  , 24005  , 24013  , 24015  , 24017  , 24021  , 24025  , 24027  , 24031  , 24033  , 24043  , 24510  , 25000  , 25001  , 25005  , 25009  , 25013  , 25015  , 25017  , 25021  , 25023  , 
25025  , 25027  , 26000  , 26005  , 26021  , 26025  , 26049  , 26075  , 26081  , 26093  , 26099  , 26115  , 26121  , 26125  , 26139  , 26145  , 26147  , 26161  , 26163  , 27000  , 27003  , 27037  , 27053  , 27123  , 27137  , 27139  , 27163  , 27171  , 28000  , 29000  , 29003  , 29019  , 29047  , 
29071  , 29095  , 29099  , 29189  , 30000  , 30111  , 31000  , 31055  , 31109  , 31153  , 32000  , 32003  , 32031  , 33000  , 33011  , 33013  , 33015  , 33017  , 34000  , 34001  , 34003  , 34005  , 34007  , 34009  , 34011  , 34013  , 34017  , 34019  , 34021  , 34023  , 34025  , 34027  , 34029  , 
34031  , 34035  , 34037  , 34039  , 34041  , 35000  , 35001  , 35013  , 35045  , 35049  , 36000  , 36005  , 36013  , 36027  , 36047  , 36055  , 36059  , 36061  , 36067  , 36069  , 36071  , 36075  , 36081  , 36085  , 36087  , 36089  , 36091  , 36103  , 36111  , 36119  , 37000  , 37001  , 37021  , 
37051  , 37057  , 37067  , 37097  , 37119  , 37129  , 37133  , 37147  , 37155  , 37159  , 37179  , 37183  , 37191  , 38000  , 38017  , 39000  , 39023  , 39025  , 39029  , 39035  , 39041  , 39045  , 39049  , 39057  , 39061  , 39085  , 39089  , 39093  , 39095  , 39103  , 39109  , 39113  , 39133  , 
39153  , 39165  , 39169  , 40000  , 40031  , 40143  , 41000  , 41017  , 41029  , 41039  , 41043  , 42000  , 42003  , 42007  , 42011  , 42013  , 42017  , 42019  , 42021  , 42029  , 42043  , 42045  , 42049  , 42051  , 42055  , 42071  , 42081  , 42085  , 42089  , 42091  , 42101  , 42107  , 42125  , 
42129  , 42133  , 44000  , 45000  , 45007  , 45041  , 45045  , 45051  , 45063  , 45079  , 45083  , 45091  , 46000  , 46083  , 46099  , 47000  , 47009  , 47093  , 47125  , 47165  , 47187  , 47189  , 48000  , 48029  , 48039  , 48041  , 48061  , 48135  , 48139  , 48141  , 48157  , 48167  , 48181  , 
48183  , 48215  , 48251  , 48303  , 48309  , 48329  , 48375  , 48381  , 48423  , 48439  , 48441  , 48479  , 48485  , 49000  , 49049  , 49053  , 50000  , 51000  , 51013  , 51041  , 51059  , 51087  , 51107  , 51153  , 51177  , 51179  , 51510  , 51550  , 51650  , 51700  , 51710  , 51740  , 51760  , 
51810  , 53000  , 53011  , 53033  , 53035  , 53053  , 53057  , 53061  , 53063  , 53067  , 53073  , 53077  , 54000  , 54039  , 55000  , 55009  , 55025  , 55059  , 55063  , 55073  , 55101  , 55105  , 55139  , 56000 ) 
all_levels <- c("Alabama, County not Identified (01000)" ,
                "Baldwin County, Alabama (01003)"  , 
                "Calhoun County, Alabama (01015)"  , 
                "Jefferson County, Alabama (01073)"  , 
                "Lee County, Alabama (01081)"  , 
                "Madison County, Alabama (01089)"  , 
                "Mobile County, Alabama (01097)"  , 
                "Shelby County, Alabama (01081)"  , 
                "Tuscaloosa County, Alabama (01125)"  , 
                "Alaska, County not Identified (02000)"  , 
                "Anchorage County, Alaska (02020)"  , 
                "Arizona, County not Identified (04000)"  , 
                "Cochise County, Arizona (04003)"  , 
                "Maricopa County, Arizona (04013)"  , 
                "Mohave County, Arizona (04015)"  , 
                "Pima County, Arizona (04019)"  , 
                "Pinal County, Arizona (04021)"  , 
                "Yavapai County, Arizona (04025)"  , 
                "Yuma County, Arizona (04027)"  , 
                "Arkansas, County not Identified (05000)"  , 
                "Pulaski County, Arkansas(05119)"  , 
                "California, County not Identified (06000)"  , 
                "Alameda County, California (06001)"  , 
                "Butte County, California (06007)"  , 
                "Contra Costa County, California (06013)"  , 
                "El Dorado County, California (06017)"  , 
                "Fresno County, California (06019)"  , 
                "Imperial County, California (06025)"  , 
                "Kern County, California (06029)"  , 
                "Kings County, California (06031)"  , 
                "Los Angeles County, California (06037)"  , 
                "Madera County, California (06039)"  , 
                "Marin County, California (06041)"  , 
                "Merced County, California (06047)"  , 
                "Monteray County, California (06053)"  , 
                "Napa County, California (06055)"  , 
                "Orange County, California (06059)"  , 
                "Placer County, California (06061)"  , 
                "Riverside County, California (06065)"  , 
                "Sacramento County, California (06067)"  , 
                "San Bernardino County, California (06071)"  , 
                "San Diego County, California (06073)"  , 
                "San Francisco County, California (06075)"  , 
                "San Joaquin County, California (06077)"  , 
                "San Luis Obispo County, California (06079)"  , 
                "San Mateo County, California (06081)"  , 
                "Santa Barbara County, California (06083)"  , 
                "Santa Clara County, California (06085)"  , 
                "Santa Cruz County, California (06087)"  , 
                "Shasta County, California (06089)"  , 
                "Solano County, California (06095)"  , 
                "Sonoma County, California (06097)"  , 
                "Stanislaus County, California (06099)"  , 
                "Tulare County, California (06107)"  , 
                "Ventura County, California (06111)"  , 
                "Yolo County, California (06113)"  , 
                "Colorado, County not Identified (08000)"  , 
                "Arapahoe County, Colorado (08005)"  , 
                "Boulder County, Colorado (08013)"  , 
                "Denver County, Colorado (08031)"  , 
                "Douglas County, Colorado (08035)"  , 
                "El Paso County, Colorado (08041)"  , 
                "Jefferson County, Colorado (08059)"  , 
                "Larimer County, Colorado (08069)"  , 
                "Pueblo County, Colorado (08101)"  , 
                "Weld County, Colorado (08123)"  , 
                "Connecticut, County not Identified (09000)"  , 
                "Fairfield County, Connecticut (09001)"  , 
                "Litchfield County, Connecticut (09005)"  , 
                "New Haven County, Connecticut (09009)"  , 
                "New London County, Connecticut (09011)"  , 
                "Windham County, Connecticut (09015)"  , 
                "Delaware, County not Identified (10000)"  , 
                "Kent County, Delaware (10001)"  , 
                "New Castle County, Delaware (10003)"  , 
                "Sussex County, Delaware (10005)"  , 
                "District of Columbia (11001)"  , 
                "Florida, County not Identified (12000)"  , 
                "Alachua County, Florida (12001)"  , 
                "Bay County, Florida (12005)"  , 
                "Brevard County, Florida (12009)"  , 
                "Broward County, Florida (12011)"  , 
                "Charlotte County, Florida (12015)"  , 
                "Clay County, Florida (12019)"  , 
                "Collier County, Florida (12021)"  , 
                "Dade County, Florida (12025)"  , 
                "Escambia County, Florida (12033)"  , 
                "Hernando County, Florida (12053)"  , 
                "Hillsborough County, Florida (12057)"  , 
                "Indian River County, Florida (12061)"  , 
                "Lake County, Florida (12069)"  , 
                "Lee County, Florida (12071)"  , 
                "Manatee County, Florida (12081)"  , 
                "Marion County, Florida (12083)"  , 
                "Martin County, Florida (12085)"  , 
                "Miami-Dade County, Florida (12086)"  , 
                "Okaloosa County, Florida (12091)"  , 
                "Orange County, Florida (12085)"  , 
                "Osceola County, Florida (12097)"  , 
                "Palm Beach County, Florida (12099)"  , 
                "Pasco County, Florida (12101)"  , 
                "Pinellas County, Florida (12103)"  , 
                "Polk County, Florida (12105)"  , 
                "St. Johns County, Florida (12109)"  , 
                "Sarasota County, Florida (12111)"  , 
                "St. Lucie County, Florida (12113)"  , 
                "Santa Rosa County, Florida (12115)"  , 
                "Seminole County, Florida (12117)"  , 
                "Volusia County, Florida (12127)"  , 
                "Georgia, County not Identified (13000)"  , 
                "Bartow County, Georgia (13015)"  , 
                "Carroll County, Georgia (13045)"  , 
                "Cherokee County, Georgia (13057)"  , 
                "Clayton County, Georgia (13063)"  , 
                "Cobb County, Georgia (13067)"  , 
                "Coweta County, Georgia (13077)"  , 
                "Dekalb County, Georgia (13089)"  , 
                "Douglas County, Georgia (13097)"  , 
                "Fayette County, Georgia (13113)"  , 
                "Forsythe County, Georgia (13117)"  , 
                "Fulton County, Georgia (13121)"  , 
                "Gwinnet County, Georgia (13135)"  , 
                "Hall County, Georgia (13139)"  , 
                "Henry County, Georgia (13151)"  , 
                "Houston County, Georgia (13153)"  , 
                "Paulding County, Georgia (13233)"  , 
                "Hawaii, County not Identified (15000)"  , 
                "Hawaii County, Hawaii (15001)"  , 
                "Honolulu County, Hawaii (15003)"  , 
                "Idaho, County not Identified (16000)"  , 
                "Kootenai County, Idaho (16055)"  , 
                "Illinois, County not Identified (17000)"  , 
                "Kankakee County, Illinois (17091)"  , 
                "Lake County, Illinois (17097)"  , 
                "LaSalle County, Illinois (17099)"  , 
                "McHenry County, Illinois (17111)"  , 
                "McLean County, Illinois (17113)"  , 
                "Macon County, Illinois (17115)"  , 
                "Madison County, Illinois (17119)"  , 
                "St. Clair County, Illinois (17163)"  , 
                "Tazewell County, Illinois (17179)"  , 
                "Indiana, County not Identified (18000)"  , 
                "Clark County, Indiana (18019)"  , 
                "Elkhart County, Indiana (18039)"  , 
                "Hamilton County, Indiana (18057)"  , 
                "Hendricks County, Indiana (18063)"  , 
                "Johnson County, Indiana (18081)"  , 
                "Lake County, Indiana (18089)"  , 
                "LaPorte County, Indiana (18091)"  , 
                "Madison County, Indiana (18095)"  , 
                "Monroe County, Indiana (18105)"  , 
                "Porter County, Indiana (18127)"  , 
                "St. Joseph County, Indiana (18141)"  , 
                "Iowa, County not Identified (19000)"  , 
                "Black Hawk County, Iowa (19013)"  , 
                "John0sonnty, Iowa (19103)"  , 
                "Linn County, Iowa (19113)"  , 
                "Polk County, Iowa (19153)"  , 
                "Scott County, Iowa (19163)"  , 
                "Kansas, County not Identified (20000)"  , 
                "Douglas County, Kansas (20045)"  , 
                "Johnson County, Kansas (20091)"  , 
                "Sedgwick County, Kansas (20173)"  , 
                "Shawnee County, Kansas (20177)"  , 
                "Kentucky, County not Identified (21000)"  , 
                "Boone County, Kentucky (21015)"  , 
                "Fayette County, Kentucky (21067)"  , 
                "Jefferson County, Kentucky (21111)"  , 
                "Kenton County, Kentucky (21117)"  , 
                "Louisiana, County not Identified (22000)"  , 
                "Ascension County, Louisiana (22005)"  , 
                "Calcasieu County, Louisiana (22019)"  , 
                "East Baton Rouge County, Louisiana (22033)"  , 
                "Jefferson County, Louisiana (22051)"  , 
                "Livingston County, Louisiana (22063)"  , 
                "Orleans County, Louisiana (22071)"  , 
                "Ouachita County, Louisiana (22073)"  , 
                "St. Tammany County, Louisiana (22103)"  , 
                "Maine, County not Identified (23000)"  , 
                "Androscoggin County, Maine (23001)"  , 
                "Cumberland County, Maine (23005)"  , 
                "Kennebec County, Maine (23011)"  , 
                "Penobscot County, Maine (23019)"  , 
                "Maryland, County not Identified (24000)"  , 
                "Anne Arundel County, Maryland (24003)"  , 
                "Baltimore County, Maryland (24005)"  , 
                "Carroll County, Maryland (24013)"  , 
                "Cecil County, Maryland (24015)"  , 
                "Charles County, Maryland (24017)"  , 
                "Frederick County, Maryland (24021)"  , 
                "Harford County, Maryland (24025)"  , 
                "Howard County, Maryland (24027)"  , 
                "Montgomery County, Maryland (24031)"  , 
                "Prince George's County, Maryland (24033)"  , 
                "Washington County, Maryland (24043)"  , 
                "Baltimore City, Maryland (24510)"  , 
                "Massachusetts, County not Identified (25000)"  , 
                "Barnstable County, Massachusetts (25001)"  , 
                "Bristol County, Massachusetts (25005)"  , 
                "Essex County, Massachusetts (25009)"  , 
                "Hampden County, Massachusetts (25013)"  , 
                "Hampshire County, Massachusetts (25015)"  , 
                "Middlesex County, Massachusetts (25017)"  , 
                "Norfolk County, Massachusetts (25021)"  , 
                "Plymouth County, Massachusetts (25023)"  , 
                "Suffolk County, Massachusetts (25025)"  , 
                "Worcester County, Massachusetts (25027)"  , 
                "Michigan, County not Identified (26000)"  , 
                "Allegan County, Michigan (26005)"  , 
                "Berrien County, Michigan (26021)"  , 
                "Calhoun County, Michigan (26025)"  , 
                "Genesee County, Michigan (26049)"  , 
                "Jackson County, Michigan (26075)"  , 
                "Kent County, Michigan (26081)"  , 
                "Livingston County, Michigan (26093)"  , 
                "Macomb County, Michigan (26099)"  , 
                "Monroe County, Michigan (26115)"  , 
                "Muskegon County, Michigan (26121)"  , 
                "Oakland County, Michigan (26125)"  , 
                "Ottawa County, Michigan (26139)"  , 
                "Saginaw County, Michigan (26145)"  , 
                "St. Clair County, Michigan (26147)"  , 
                "Washtenaw County, Michigan (26161)"  , 
                "Wayne County, Michigan (26163)"  , 
                "Minnesota, County not Identified (27000)"  , 
                "Anoka County, Minnesota (27003)"  , 
                "Dakota County, Minnesota (27037)"  , 
                "Hennepin County, Minnesota (27053)"  , 
                "Ramsey County, Minnesota (27123)"  , 
                "St. Louis County, Minnesota (27137)"  , 
                "Scott County, Minnesota (27139)"  , 
                "Washington County, Minnesota (27163)"  , 
                "Wright County, Minnesota (27171)"  , 
                "Mississippi, County not Identified (28000)"  , 
                "Missouri, County not Identified (29000)"  , 
                "Andrew County, Missouri (29003)"  , 
                "Boone County, Missouri (29019)"  , 
                "Clay County, Missouri (29047)"  , 
                "Franklin County, Missouri (29071)"  , 
                "Jackson County, Missouri (29095)"  , 
                "Jefferson County, Missouri (29099)"  , 
                "St. Louis County, Missouri (29189)"  , 
                "Montana, County not Identified (30000)"  , 
                "Yellowstone County, Montana (30111)"  , 
                "Nebraska, County not Identified (31000)"  , 
                "Douglas County, Nebraska (31055)"  , 
                "Lancaster County, Nebraska (31109)"  , 
                "Sarpy County, Nebraska (31153)"  , 
                "Nevada, County not Identified (32000)"  , 
                "Clark County, Nevada (32003)"  , 
                "Washoe County, Nevada (32031)"  , 
                "New Hampshire, County not Identified (33000)"  , 
                "Hillsborough County, New Hampshire (33011)"  , 
                "Merrimack County, New Hampshire (33013)"  , 
                "Rockingham County, New Hampshire (33015)"  , 
                "Strafford County, New Hampshire (33017)"  , 
                "New Jersey, County not Identified (34000)"  , 
                "Atlantic County, New Jersey (34001)"  , 
                "Bergen County, New Jersey (34003)"  , 
                "Burlington County, New Jersey (34005)"  , 
                "Camden County, New Jersey (34007)"  , 
                "Cape May County, New Jersey (34009)"  , 
                "Cumberland County, New Jersey (34011)"  , 
                "Essex County, New Jersey (34013)"  , 
                "Hudson County, New Jersey (34017)"  , 
                "Hunterdon County, New Jersey (34019)"  , 
                "Mercer County, New Jersey (34021)"  , 
                "Middlesex County, New Jersey (34023)"  , 
                "Monmouth County, New Jersey (34025)"  , 
                "Morris County, New Jersey (34027)"  , 
                "Ocean County, New Jersey (34029)"  , 
                "Passaic County, New Jersey (34031)"  , 
                "Somerset County, New Jersey (34035)"  , 
                "Sussex County, New Jersey (34037)"  , 
                "Union County, New Jersey (34039)"  , 
                "Warren County, New Jersey (34041)"  , 
                "New Mexico, County not Identified (35000)"  , 
                "Bernalillo County, New Mexico (35001)"  , 
                "Dona Ana County, New Mexico (35013)"  , 
                "San Juan County, New Mexico (35045)"  , 
                "Santa Fe County, New Mexico (35049)"  , 
                "New York, County not Identified (36000)"  , 
                "Bronx County, New York (36005)"  , 
                "Chautauqua County, New York (36013)"  , 
                "Dutchess County, New York (36027)"  , 
                "Kings County, New York (36047)"  , 
                "Monroe County, New York (36055)"  , 
                "Nassau County, New York (36059)"  , 
                "New York County, New York (36061)"  , 
                "Onondaga County, New York (36067)"  , 
                "Ontario County, New York (36069)"  , 
                "Orange County, New York (36071)"  , 
                "Oswego County, New York (36075)"  , 
                "Queens County, New York (36081)"  , 
                "Richmond County, New York (36085)"  , 
                "Rockland County, New York (36087)"  , 
                "St. Lawrence County, New York (36089)"  , 
                "Saratoga County, New York (36091)"  , 
                "Suffolk County, New York (36103)"  , 
                "Ulster County, New York (36111)"  , 
                "Westchester County, New York (36119)"  , 
                "North Carolina, County not Identified (37000)"  , 
                "Alamance County, North Carolina (37001)"  , 
                "Buncombe County, North Carolina (37021)"  , 
                "Cumberland County, North Carolina (37051)"  , 
                "Davidson County, North Carolina (37057)"  , 
                "Forsythe County, North Carolina (37067)"  , 
                "Iredell County, North Carolina (37097)"  , 
                "Mecklenburg County, North Carolina (37119)"  , 
                "New Hanover County, North Carolina (37129)"  , 
                "Onslow County, North Carolina (37133)"  , 
                "Pitt County, North Carolina (37147)"  , 
                "Robeson County, North Carolina (37155)"  , 
                "Rowan County, North Carolina (37159)"  , 
                "Union County, North Carolina (37179)"  , 
                "Wake County, North Carolina (37183)"  , 
                "Wayne County, North Carolina (37191)"  , 
                "North Dakota, County not Identified (38000)"  , 
                "Class County, North Dakota (38017)"  , 
                "Ohio, County not Identified (39000)"  , 
                "Clark County, Ohio (39023)"  , 
                "Clermont County, Ohio (39025)"  , 
                "Columbiana County, Ohio (39029)"  , 
                "Cuyahoga County, Ohio (39035)"  , 
                "Delaware County, Ohio (39041)"  , 
                "Fairfield County, Ohio (39045)"  , 
                "Franklin County, Ohio (39049)"  , 
                "Greene County, Ohio (39057)"  , 
                "Hamilton County, Ohio (39061)"  , 
                "Lake County, Ohio (39085)"  , 
                "Licking County, Ohio (39089)"  , 
                "Lorain County, Ohio (39093)"  , 
                "Lucas County, Ohio (39095)"  , 
                "Medina County, Ohio (39103)"  , 
                "Miami County, Ohio (39109)"  , 
                "Montgomery County, Ohio (39113)"  , 
                "Portage County, Ohio (39133)"  , 
                "Summit County, Ohio (39153)"  , 
                "Warren County, Ohio (39165)"  , 
                "Wayne County, Ohio (39169)"  , 
                "Oklahoma, County not Identified (40000)"  , 
                "Comanche County, Oklahoma (40031)"  , 
                "Tulsa County, Oklahoma (40143)"  , 
                "Oregon, County not Identified (41000)"  , 
                "Deschutes County, Oregon (41017)"  , 
                "Jackson County, Oregon (41029)"  , 
                "Lane County, Oregon (41039)"  , 
                "Linn County, Oregon (41041)"  , 
                "Pennsylvania, County not Identified (42000)"  , 
                "Allegheny County, Pennsylvania (42003)"  , 
                "Beaver County, Pennsylvania (42007)"  , 
                "Berks County, Pennsylvania (42011)"  , 
                "Blair County, Pennsylvania (42013)"  , 
                "Bucks County, Pennsylvania (42017)"  , 
                "Butler County, Pennsylvania (42019)"  , 
                "Cambria County, Pennsylvania (42021)"  , 
                "Chester County, Pennsylvania (42029)"  , 
                "Dauphin County, Pennsylvania (42043)"  , 
                "Delaware County, Pennsylvania (42045)"  , 
                "Erie County, Pennsylvania (42049)"  , 
                "Fayette County, Pennsylvania (42051)"  , 
                "Franklin County, Pennsylvania (42055)"  , 
                "Lancaster County, Pennsylvania (42071)"  , 
                "Lycoming County, Pennsylvania (42081)"  , 
                "Mercer County, Pennsylvania (42085)"  , 
                "Monroe County, Pennsylvania (42089)"  , 
                "Montgomery County, Pennsylvania (42091)"  , 
                "Philadelphia County, Pennsylvania (42101)"  , 
                "Schuylkill County, Pennsylvania (42107)"  , 
                "Washington County, Pennsylvania (42125)"  , 
                "Westmoreland County, Pennsylvania (42129)"  , 
                "York County, Pennsylvania (42133)"  , 
                "Rhode Island, County not Identified (44000)"  , 
                "South Carolina, County not Identified (45000)"  , 
                "Anderson County, South Carolina (45007)"  , 
                "Florence County, South Carolina (45041)"  , 
                "Greenville County, South Carolina (45045)"  , 
                "Horry County, South Carolina (45051)"  , 
                "Lexington County, South Carolina (45063)"  , 
                "Richland County, South Carolina (45079)"  , 
                "Spartanburg County, South Carolina (45083)"  , 
                "York County, South Carolina (45091)"  , 
                "South Dakota, County not Identified (46000)"  , 
                "Lincoln County, South Dakota (46083)"  , 
                "Minnehaha County, South Dakota (46099)"  , 
                "Tennessee, County not Identified (47000)"  , 
                "Blount County, Tennessee (47009)"  , 
                "Knox County, Tennessee (47093)"  , 
                "Montgomery County, Tennessee (47125)"  , 
                "Sumner County, Tennessee (47165)"  , 
                "Williamson County, Tennessee (47187)"  , 
                "Wilson County, Tennessee (47189)"  , 
                "Texas, County not Identified (48000)"  , 
                "Bexar County, Texas (48029)"  , 
                "Brazoria County, Texas (48039)"  , 
                "Brazos County, Texas (48041)"  , 
                "Cameron County, Texas (48061)"  , 
                "Ector County, Texas (48135)"  , 
                "Ellis County, Texas (48139)"  , 
                "El Paso County, Texas (48141)"  , 
                "Fort Bend County, Texas (48157)"  , 
                "Galveston County, Texas (48167)"  , 
                "Grayson County, Texas (48181)"  , 
                "Gregg County, Texas (48183)"  , 
                "Hidalgo County, Texas (48215)"  , 
                "Johnson County, Texas (48251)"  , 
                "Lubbock County, Texas (48303)"  , 
                "McLennan County, Texas (48309)"  , 
                "Midland County, Texas (48329)"  , 
                "Potter County, Texas (48375)"  , 
                "Randall County, Texas (48381)"  , 
                "Smith County, Texas (48423)"  , 
                "Tarrant County, Texas (48439)"  , 
                "Taylor County, Texas (48441)"  , 
                "Webb County, Texas (48479)"  , 
                "Wichita County, Texas (48485)"  , 
                "Utah, County not Identified (49000)"  , 
                "Utah County, Utah (49049)"  , 
                "Washington County, Utah (49053)"  , 
                "Vermont, County not Identified (50000)"  , 
                "Virginia, County not Identified (51000)"  , 
                "Arlington County, Virginia (51013)"  , 
                "Chesterfield County, Virginia (51041)"  , 
                "Fairfax County, Virginia (51059)"  , 
                "Henrico County, Virginia (51087)"  , 
                "Loudoun County, Virginia (51107)"  , 
                "Prince William County, Virginia (51153)"  , 
                "Spotsylvania County, Virginia (51177)"  , 
                "Stafford County, Virginia (51179)"  , 
                "Alexandria City County, Virginia (51510)"  , 
                "Chesapeake City County, Virginia (51550)"  , 
                "Hampton City County, Virginia (51650)"  , 
                "Newport News City County, Virginia (51700)"  , 
                "Norfolk City County, Virginia (51710)"  , 
                "Portsmouth City County, Virginia (51740)"  , 
                "Richmond City County, Virginia (51760)"  , 
                "Virginia Beach City County, Virginia (51810)"  , 
                "Washington, County not Identified (53000)"  , 
                "Clark County, Washington (53011)"  , 
                "King County, Washington (53033)"  , 
                "Kitsap County, Washington (53035)"  , 
                "Pierce County, Washington (53053)"  , 
                "Skagit County, Washington (53057)"  , 
                "Snohomish County, Washington (53061)"  , 
                "Spokane County, Washington (53063)"  , 
                "Thurston County, Washington (53067)"  , 
                "Whatcom County, Washington (53073)"  , 
                "Yakima County, Washington (53077)"  , 
                "West Virginia, County not Identified (54000)"  , 
                "Kanawha County, West Virginia (54039)"  , 
                "Wisconsin, County not Identified (55000)"  , 
                "Brown County, Wisconsin (55009)"  , 
                "Dane County, Wisconsin (55025)"  , 
                "Kenosha County, Wisconsin (55059)"  , 
                "Lacrosse County, Wisconsin (55063)"  , 
                "Marathon County, Wisconsin (55073)"  , 
                "Racine County, Wisconsin (55101)"  , 
                "Rock County, Wisconsin (55105)"  , 
                "Winnebago County, Wisconsin (55139)"  , 
                "Wyoming, County not Identified (56000)" ) 
var_levels <-  levels(Harmon$StCounty)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$StCounty)[valid_positions] <- valid_labels
table(Harmon$StCounty, useNA="ifany")


# Variable:SurMonth Format: SURMONTF levels:8
Harmon$SurMonth <- as.factor(Harmon$SurMonth)
all_values <- c(1 ,2  , 5  , 6  , 7  , 8  , 9  , 11 ) 
all_levels <- c("1: January" ,
                "2: February"  , 
                "5: May"  , 
                "6: June"  , 
                "7: July"  , 
                "8: August"  , 
                "9: September"  , 
                "11: November" ) 
var_levels <-  levels(Harmon$SurMonth)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SurMonth)[valid_positions] <- valid_labels
table(Harmon$SurMonth, useNA="ifany")


# Variable:SurWave Format: SURWAVEF levels:10
Harmon$SurWave <- as.factor(Harmon$SurWave)
all_values <- c(1 ,2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10 ) 
all_levels <- c("1992-1993" ,
                "1995-1996"  , 
                "1998-1999"  , 
                "2000"  , 
                "2001-2002"  , 
                "2003"  , 
                "2006-2007"  , 
                "2010-2011"  , 
                "2014-2015"  , 
                "2018-2019" ) 
var_levels <-  levels(Harmon$SurWave)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$SurWave)[valid_positions] <- valid_labels
table(Harmon$SurWave, useNA="ifany")


# Variable:TTFC Format: TTFCF levels:5
Harmon$TTFC <- as.factor(Harmon$TTFC)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-5: Varies"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$TTFC)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$TTFC)[valid_positions] <- valid_labels
table(Harmon$TTFC, useNA="ifany")


# Variable:TTFC30 Format: TTFC30F levels:7
Harmon$TTFC30 <- as.factor(Harmon$TTFC30)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No"  , 
                "3: Varies" ) 
var_levels <-  levels(Harmon$TTFC30)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$TTFC30)[valid_positions] <- valid_labels
table(Harmon$TTFC30, useNA="ifany")


# Variable:TTFOTP Format: TTFOTPF levels:5
Harmon$TTFOTP <- as.factor(Harmon$TTFOTP)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-5: Varies"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$TTFOTP)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$TTFOTP)[valid_positions] <- valid_labels
table(Harmon$TTFOTP, useNA="ifany")


# Variable:TTFOTP30 Format: TTFO30F levels:7
Harmon$TTFOTP30 <- as.factor(Harmon$TTFOTP30)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No"  , 
                "3: Varies" ) 
var_levels <-  levels(Harmon$TTFOTP30)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$TTFOTP30)[valid_positions] <- valid_labels
table(Harmon$TTFOTP30, useNA="ifany")


# Variable:WKAREA03 Format: WKAREA0F levels:10
Harmon$WKAREA03 <- as.factor(Harmon$WKAREA03)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3  , 4  , 5  , 6 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Mainly work indoors"  , 
                "2: Mainly work outdoors"  , 
                "3: Travel to different buildings or sites"  , 
                "4: In motor vehicle"  , 
                "5: Somewhere else"  , 
                "6: Varies (not read)" ) 
var_levels <-  levels(Harmon$WKAREA03)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WKAREA03)[valid_positions] <- valid_labels
table(Harmon$WKAREA03, useNA="ifany")


# Variable:WKAREA10 Format: WKAREA1F levels:10
Harmon$WKAREA10 <- as.factor(Harmon$WKAREA10)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3  , 4  , 5  , 6 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Indoors"  , 
                "2: Outdoors"  , 
                "3: About equally indoors and outdoors"  , 
                "4: Works mainly indoors in a non-traditional environment such as warehouse or other similar large semi-structured area"  , 
                "5: Mainly travel around to different clients or sites or mainly in motor vehicle/bus/train/boat/airplane/underground/in a mine, etc."  , 
                "6: Varies" ) 
var_levels <-  levels(Harmon$WKAREA10)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WKAREA10)[valid_positions] <- valid_labels
table(Harmon$WKAREA10, useNA="ifany")


# Variable:WKAREA92 Format: WKAREA9F levels:14
Harmon$WKAREA92 <- as.factor(Harmon$WKAREA92)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3  , 4  , 5  , 6  , 7  , 8  , 9  , 10 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Private enclosed office with door"  , 
                "2: Shared enclosed office with door"  , 
                "3: Indoor open area with or without partitions"  , 
                "4: In one building, but no regular work area"  , 
                "5: Store or restaurant"  , 
                "6: Warehouse or factory"  , 
                "7: In someone's home"  , 
                "8: Travel to different buildings or sites"  , 
                "9: Outdoors or in a motor vehicle"  , 
                "10: Other" ) 
var_levels <-  levels(Harmon$WKAREA92)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WKAREA92)[valid_positions] <- valid_labels
table(Harmon$WKAREA92, useNA="ifany")


# Variable:WKINDPL1 Format: WKINDPLF levels:8
Harmon$WKINDPL1 <- as.factor(Harmon$WKINDPL1)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3  , 4 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Office building"  , 
                "2: Own home"  , 
                "3: Someone else's home"  , 
                "4: Another indoor place" ) 
var_levels <-  levels(Harmon$WKINDPL1)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WKINDPL1)[valid_positions] <- valid_labels
table(Harmon$WKINDPL1, useNA="ifany")


# Variable:WKINDPL2 Format: WKINDPLF levels:8
Harmon$WKINDPL2 <- as.factor(Harmon$WKINDPL2)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3  , 4 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Office building"  , 
                "2: Own home"  , 
                "3: Someone else's home"  , 
                "4: Another indoor place" ) 
var_levels <-  levels(Harmon$WKINDPL2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WKINDPL2)[valid_positions] <- valid_labels
table(Harmon$WKINDPL2, useNA="ifany")


# Variable:WKINDPLC Format: WKINDPLF levels:8
Harmon$WKINDPLC <- as.factor(Harmon$WKINDPLC)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3  , 4 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Office building"  , 
                "2: Own home"  , 
                "3: Someone else's home"  , 
                "4: Another indoor place" ) 
var_levels <-  levels(Harmon$WKINDPLC)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WKINDPLC)[valid_positions] <- valid_labels
table(Harmon$WKINDPLC, useNA="ifany")


# Variable:WKPOLICY Format: WKPOLICF levels:6
Harmon$WKPOLICY <- as.factor(Harmon$WKPOLICY)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$WKPOLICY)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WKPOLICY)[valid_positions] <- valid_labels
table(Harmon$WKPOLICY, useNA="ifany")


# Variable:WKPOLIND Format: WKPOLINF levels:8
Harmon$WKPOLIND <- as.factor(Harmon$WKPOLIND)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3  , 4 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know (not read)"  , 
                "-1: Not in universe"  , 
                "1: Not allowed in any public areas"  , 
                "2: Allowed in some public areas"  , 
                "3: Allowed in all public areas"  , 
                "4: Not applicable (not read)" ) 
var_levels <-  levels(Harmon$WKPOLIND)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WKPOLIND)[valid_positions] <- valid_labels
table(Harmon$WKPOLIND, useNA="ifany")


# Variable:WKPOLWRK Format: WKPOLWRF levels:8
Harmon$WKPOLWRK <- as.factor(Harmon$WKPOLWRK)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3  , 4 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know (not read)"  , 
                "-1: Not in universe"  , 
                "1: Not allowed in any work areas"  , 
                "2: Allowed in some work areas"  , 
                "3: Allowed in all work areas"  , 
                "4: Not applicable (not read)" ) 
var_levels <-  levels(Harmon$WKPOLWRK)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WKPOLWRK)[valid_positions] <- valid_labels
table(Harmon$WKPOLWRK, useNA="ifany")


# Variable:WKSMK2WK Format: WKSMK2WF levels:6
Harmon$WKSMK2WK <- as.factor(Harmon$WKSMK2WK)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$WKSMK2WK)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WKSMK2WK)[valid_positions] <- valid_labels
table(Harmon$WKSMK2WK, useNA="ifany")


# Variable:WKSTATE Format: WKSTATEF levels:59
Harmon$WKSTATE <- as.factor(Harmon$WKSTATE)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 4  , 5  , 6  , 8  , 9  , 10  , 11  , 12  , 13  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23  , 24  , 25  , 26  , 27  , 28  , 29  , 30  , 31  , 32  , 33  , 34  , 35  , 36  , 37  , 38  , 39  , 40  , 41  , 42  , 44  , 45  , 46  , 47  , 48  , 49
 , 50  , 51  , 53  , 54  , 55  , 56  , 57  , 88  , 98  , 99 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Alabama"  , 
                "2: Alaska"  , 
                "4: Arizona"  , 
                "5: Arkansas"  , 
                "6: California"  , 
                "8: Colorado"  , 
                "9: Connecticut"  , 
                "10: Delaware"  , 
                "11: District of Columbia"  , 
                "12: Florida"  , 
                "13: Georgia"  , 
                "15: Hawaii"  , 
                "16: Idaho"  , 
                "17: Illinois"  , 
                "18: Indiana"  , 
                "19: Iowa"  , 
                "20: Kansas"  , 
                "21: Kentucky"  , 
                "22: Louisiana"  , 
                "23: Maine"  , 
                "24: Maryland"  , 
                "25: Massachusetts"  , 
                "26: Michigan"  , 
                "27: Minnesota"  , 
                "28: Mississippi"  , 
                "29: Missouri"  , 
                "30: Montana"  , 
                "31: Nebraska"  , 
                "32: Nevada"  , 
                "33: New Hampshire"  , 
                "34: New Jersey"  , 
                "35: New Mexico"  , 
                "36: New York"  , 
                "37: North Carolina"  , 
                "38: North Dakota"  , 
                "39: Ohio"  , 
                "40: Oklahoma"  , 
                "41: Oregon"  , 
                "42: Pennsylvania"  , 
                "44: Rhode Island"  , 
                "45: South Carolina"  , 
                "46: South Dakota"  , 
                "47: Tennessee"  , 
                "48: Texas"  , 
                "49: Utah"  , 
                "50: Vermont"  , 
                "51: Virginia"  , 
                "53: Washington"  , 
                "54: West Virginia"  , 
                "55: Wisconsin"  , 
                "56: Wyoming"  , 
                "57: United States (state unknown)"  , 
                "88: Not in the U.S."  , 
                "98: Unknown"  , 
                "99: NA" ) 
var_levels <-  levels(Harmon$WKSTATE)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WKSTATE)[valid_positions] <- valid_labels
table(Harmon$WKSTATE, useNA="ifany")


# Variable:WKSTATE1 Format: WKSTATEF levels:59
Harmon$WKSTATE1 <- as.factor(Harmon$WKSTATE1)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 4  , 5  , 6  , 8  , 9  , 10  , 11  , 12  , 13  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23  , 24  , 25  , 26  , 27  , 28  , 29  , 30  , 31  , 32  , 33  , 34  , 35  , 36  , 37  , 38  , 39  , 40  , 41  , 42  , 44  , 45  , 46  , 47  , 48  , 49
 , 50  , 51  , 53  , 54  , 55  , 56  , 57  , 88  , 98  , 99 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Alabama"  , 
                "2: Alaska"  , 
                "4: Arizona"  , 
                "5: Arkansas"  , 
                "6: California"  , 
                "8: Colorado"  , 
                "9: Connecticut"  , 
                "10: Delaware"  , 
                "11: District of Columbia"  , 
                "12: Florida"  , 
                "13: Georgia"  , 
                "15: Hawaii"  , 
                "16: Idaho"  , 
                "17: Illinois"  , 
                "18: Indiana"  , 
                "19: Iowa"  , 
                "20: Kansas"  , 
                "21: Kentucky"  , 
                "22: Louisiana"  , 
                "23: Maine"  , 
                "24: Maryland"  , 
                "25: Massachusetts"  , 
                "26: Michigan"  , 
                "27: Minnesota"  , 
                "28: Mississippi"  , 
                "29: Missouri"  , 
                "30: Montana"  , 
                "31: Nebraska"  , 
                "32: Nevada"  , 
                "33: New Hampshire"  , 
                "34: New Jersey"  , 
                "35: New Mexico"  , 
                "36: New York"  , 
                "37: North Carolina"  , 
                "38: North Dakota"  , 
                "39: Ohio"  , 
                "40: Oklahoma"  , 
                "41: Oregon"  , 
                "42: Pennsylvania"  , 
                "44: Rhode Island"  , 
                "45: South Carolina"  , 
                "46: South Dakota"  , 
                "47: Tennessee"  , 
                "48: Texas"  , 
                "49: Utah"  , 
                "50: Vermont"  , 
                "51: Virginia"  , 
                "53: Washington"  , 
                "54: West Virginia"  , 
                "55: Wisconsin"  , 
                "56: Wyoming"  , 
                "57: United States (state unknown)"  , 
                "88: Not in the U.S."  , 
                "98: Unknown"  , 
                "99: NA" ) 
var_levels <-  levels(Harmon$WKSTATE1)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WKSTATE1)[valid_positions] <- valid_labels
table(Harmon$WKSTATE1, useNA="ifany")


# Variable:WKSTATE2 Format: WKSTATEF levels:59
Harmon$WKSTATE2 <- as.factor(Harmon$WKSTATE2)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 4  , 5  , 6  , 8  , 9  , 10  , 11  , 12  , 13  , 15  , 16  , 17  , 18  , 19  , 20  , 21  , 22  , 23  , 24  , 25  , 26  , 27  , 28  , 29  , 30  , 31  , 32  , 33  , 34  , 35  , 36  , 37  , 38  , 39  , 40  , 41  , 42  , 44  , 45  , 46  , 47  , 48  , 49
 , 50  , 51  , 53  , 54  , 55  , 56  , 57  , 88  , 98  , 99 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Alabama"  , 
                "2: Alaska"  , 
                "4: Arizona"  , 
                "5: Arkansas"  , 
                "6: California"  , 
                "8: Colorado"  , 
                "9: Connecticut"  , 
                "10: Delaware"  , 
                "11: District of Columbia"  , 
                "12: Florida"  , 
                "13: Georgia"  , 
                "15: Hawaii"  , 
                "16: Idaho"  , 
                "17: Illinois"  , 
                "18: Indiana"  , 
                "19: Iowa"  , 
                "20: Kansas"  , 
                "21: Kentucky"  , 
                "22: Louisiana"  , 
                "23: Maine"  , 
                "24: Maryland"  , 
                "25: Massachusetts"  , 
                "26: Michigan"  , 
                "27: Minnesota"  , 
                "28: Mississippi"  , 
                "29: Missouri"  , 
                "30: Montana"  , 
                "31: Nebraska"  , 
                "32: Nevada"  , 
                "33: New Hampshire"  , 
                "34: New Jersey"  , 
                "35: New Mexico"  , 
                "36: New York"  , 
                "37: North Carolina"  , 
                "38: North Dakota"  , 
                "39: Ohio"  , 
                "40: Oklahoma"  , 
                "41: Oregon"  , 
                "42: Pennsylvania"  , 
                "44: Rhode Island"  , 
                "45: South Carolina"  , 
                "46: South Dakota"  , 
                "47: Tennessee"  , 
                "48: Texas"  , 
                "49: Utah"  , 
                "50: Vermont"  , 
                "51: Virginia"  , 
                "53: Washington"  , 
                "54: West Virginia"  , 
                "55: Wisconsin"  , 
                "56: Wyoming"  , 
                "57: United States (state unknown)"  , 
                "88: Not in the U.S."  , 
                "98: Unknown"  , 
                "99: NA" ) 
var_levels <-  levels(Harmon$WKSTATE2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WKSTATE2)[valid_positions] <- valid_labels
table(Harmon$WKSTATE2, useNA="ifany")


# Variable:WKSTPSMK Format: WKSTPSMF levels:6
Harmon$WKSTPSMK <- as.factor(Harmon$WKSTPSMK)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Yes"  , 
                "2: No" ) 
var_levels <-  levels(Harmon$WKSTPSMK)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WKSTPSMK)[valid_positions] <- valid_labels
table(Harmon$WKSTPSMK, useNA="ifany")


# Variable:WORKBAN Format: WORKBANF levels:5
Harmon$WORKBAN <- as.factor(Harmon$WORKBAN)
all_values <- c(-9 ,-1  , 1  , 2  , 3 ) 
all_levels <- c("-9: Indeterminate" ,
                "-1: Not in universe"  , 
                "1: Not allowed in any indoor public or work areas"  , 
                "2: Allowed in some/all indoor public or work areas or not applicable"  , 
                "3: No policy" ) 
var_levels <-  levels(Harmon$WORKBAN)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WORKBAN)[valid_positions] <- valid_labels
table(Harmon$WORKBAN, useNA="ifany")


# Variable:WRKCLSS1 Format: WRKCLSSF levels:9
Harmon$WRKCLSS1 <- as.factor(Harmon$WRKCLSS1)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Government - federal"  , 
                "2: Government - state"  , 
                "3: Government - local"  , 
                "4: Private, for profit"  , 
                "5: Private, nonprofit"  , 
                "6: Self-employed, incorporated"  , 
                "7: Self-employed, unincorporated"  , 
                "8: Without pay" ) 
var_levels <-  levels(Harmon$WRKCLSS1)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WRKCLSS1)[valid_positions] <- valid_labels
table(Harmon$WRKCLSS1, useNA="ifany")


# Variable:WRKCLSS2 Format: WRKCLSSF levels:9
Harmon$WRKCLSS2 <- as.factor(Harmon$WRKCLSS2)
all_values <- c(-1 ,1  , 2  , 3  , 4  , 5  , 6  , 7  , 8 ) 
all_levels <- c("-1: Not in universe" ,
                "1: Government - federal"  , 
                "2: Government - state"  , 
                "3: Government - local"  , 
                "4: Private, for profit"  , 
                "5: Private, nonprofit"  , 
                "6: Self-employed, incorporated"  , 
                "7: Self-employed, unincorporated"  , 
                "8: Without pay" ) 
var_levels <-  levels(Harmon$WRKCLSS2)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$WRKCLSS2)[valid_positions] <- valid_labels
table(Harmon$WRKCLSS2, useNA="ifany")


# Variable:XPYSTPDC Format: XPYSTPCF levels:7
Harmon$XPYSTPDC <- as.factor(Harmon$XPYSTPDC)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Once (1 time)"  , 
                "2: 2-3 times"  , 
                "3: 4 or more times" ) 
var_levels <-  levels(Harmon$XPYSTPDC)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$XPYSTPDC)[valid_positions] <- valid_labels
table(Harmon$XPYSTPDC, useNA="ifany")


# Variable:XPYSTPDN Format: XPYSTPNF levels:4
Harmon$XPYSTPDN <- as.factor(Harmon$XPYSTPDN)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$XPYSTPDN)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$XPYSTPDN)[valid_positions] <- valid_labels
table(Harmon$XPYSTPDN, useNA="ifany")


# Variable:XPYSTPSC Format: XPYSTPCF levels:7
Harmon$XPYSTPSC <- as.factor(Harmon$XPYSTPSC)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: Once (1 time)"  , 
                "2: 2-3 times"  , 
                "3: 4 or more times" ) 
var_levels <-  levels(Harmon$XPYSTPSC)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$XPYSTPSC)[valid_positions] <- valid_labels
table(Harmon$XPYSTPSC, useNA="ifany")


# Variable:XPYSTPSN Format: XPYSTPNF levels:4
Harmon$XPYSTPSN <- as.factor(Harmon$XPYSTPSN)
all_values <- c(-9 ,-3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$XPYSTPSN)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$XPYSTPSN)[valid_positions] <- valid_labels
table(Harmon$XPYSTPSN, useNA="ifany")


# Variable:YEARINUS Format: YEARINUF levels:1
Harmon$YEARINUS <- as.factor(Harmon$YEARINUS)
all_values <- c(-1 )
all_levels <- c("-1: Not foreign born" )
var_levels <-  levels(Harmon$YEARINUS)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$YEARINUS)[valid_positions] <- valid_labels
table(Harmon$YEARINUS, useNA="ifany")



# Variable:YRSSMKDC Format: YRSSMKCF levels:5
Harmon$YRSSMKDC <- as.factor(Harmon$YRSSMKDC)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-5: None or less than 1 year"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$YRSSMKDC)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$YRSSMKDC)[valid_positions] <- valid_labels
table(Harmon$YRSSMKDC, useNA="ifany")


# Variable:YRSSMKDG Format: YRSSMKGF levels:9
Harmon$YRSSMKDG <- as.factor(Harmon$YRSSMKDG)
all_values <- c(-9 ,-3  , -2  , -1  , 1  , 2  , 3  , 4  , 5 ) 
all_levels <- c("-9: No response" ,
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe"  , 
                "1: All or nearly all the years you have smoked"  , 
                "2: Most of the years you have smoked"  , 
                "3: Half of the years you have smoked"  , 
                "4: Less than half the years you have smoked"  , 
                "5: Less than one year" ) 
var_levels <-  levels(Harmon$YRSSMKDG)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$YRSSMKDG)[valid_positions] <- valid_labels
table(Harmon$YRSSMKDG, useNA="ifany")


# Variable:YRSSMKDH Format: YRSSMKCF levels:5
Harmon$YRSSMKDH <- as.factor(Harmon$YRSSMKDH)
all_values <- c(-9 ,-5  , -3  , -2  , -1 ) 
all_levels <- c("-9: No response" ,
                "-5: None or less than 1 year"  , 
                "-3: Refused"  , 
                "-2: Don't know"  , 
                "-1: Not in universe" ) 
var_levels <-  levels(Harmon$YRSSMKDH)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Harmon$YRSSMKDH)[valid_positions] <- valid_labels
table(Harmon$YRSSMKDH, useNA="ifany")

all_values <- all_levels <- valid_positions <- NULL

